/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.RootLayoutArea;
import com.itextpdf.layout.properties.AreaBreakType;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;

public class ColumnDocumentRenderer
extends DocumentRenderer {
    protected Rectangle[] columns;
    protected int nextAreaNumber;

    public ColumnDocumentRenderer(Document document, Rectangle[] columns) {
        super(document);
        this.columns = columns;
    }

    public ColumnDocumentRenderer(Document document, boolean immediateFlush, Rectangle[] columns) {
        super(document, immediateFlush);
        this.columns = columns;
    }

    public int getNextAreaNumber() {
        return this.nextAreaNumber;
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ColumnDocumentRenderer(this.document, this.immediateFlush, this.columns);
    }

    @Override
    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        if (overflowResult != null && overflowResult.getAreaBreak() != null && overflowResult.getAreaBreak().getType() != AreaBreakType.NEXT_AREA) {
            this.nextAreaNumber = 0;
        }
        if (this.nextAreaNumber % this.columns.length == 0) {
            super.updateCurrentArea(overflowResult);
        }
        this.currentArea = new RootLayoutArea(this.currentArea.getPageNumber(), this.columns[this.nextAreaNumber++ % this.columns.length].clone());
        return this.currentArea;
    }
}

