/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.property;

import com.itextpdf.io.util.MessageFormatUtil;

public class UnitValue {
    public static final int POINT = 1;
    public static final int PERCENT = 2;
    protected int unitType;
    protected float value;

    public UnitValue(int unitType, float value) {
        this.unitType = unitType;
        assert (!Float.isNaN(value));
        this.value = value;
    }

    public UnitValue(UnitValue unitValue) {
        this(unitValue.unitType, unitValue.value);
    }

    public static UnitValue createPointValue(float value) {
        return new UnitValue(1, value);
    }

    public static UnitValue createPercentValue(float value) {
        return new UnitValue(2, value);
    }

    public static UnitValue[] createPercentArray(float[] values) {
        UnitValue[] resultArray = new UnitValue[values.length];
        float sum = 0.0f;
        for (float val : values) {
            sum += val;
        }
        for (int i = 0; i < values.length; ++i) {
            resultArray[i] = UnitValue.createPercentValue(100.0f * values[i] / sum);
        }
        return resultArray;
    }

    public static UnitValue[] createPointArray(float[] values) {
        UnitValue[] resultArray = new UnitValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            resultArray[i] = UnitValue.createPointValue(values[i]);
        }
        return resultArray;
    }

    public int getUnitType() {
        return this.unitType;
    }

    public void setUnitType(int unitType) {
        this.unitType = unitType;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        assert (!Float.isNaN(value));
        this.value = value;
    }

    public boolean isPointValue() {
        return this.unitType == 1;
    }

    public boolean isPercentValue() {
        return this.unitType == 2;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitValue other = (UnitValue)obj;
        return Integer.compare(this.unitType, other.unitType) == 0 && Float.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.unitType;
        hash = 71 * hash + Float.floatToIntBits(this.value);
        return hash;
    }

    public String toString() {
        return MessageFormatUtil.format((String)(this.unitType == 2 ? "{0}%" : "{0}pt"), (Object[])new Object[]{Float.valueOf(this.value)});
    }
}

