/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import java.util.Arrays;

public class BitmapImagePixels {
    private static final int BITS_IN_BYTE = 8;
    private static final int DEFAULT_BITS_PER_COMPONENT = 8;
    private static final int BYTE_WITH_LEADING_BIT = 128;
    private static final int BITS_IN_BYTE_LOG = 3;
    private static final int BIT_MASK = 7;
    private final int width;
    private final int bitsInRow;
    private final int height;
    private final int bitsPerComponent;
    private final int maxComponentValue;
    private final int numberOfComponents;
    private final byte[] data;

    public BitmapImagePixels(int width, int height, int bitsPerComponent, int numberOfComponents) {
        this(width, height, bitsPerComponent, numberOfComponents, null);
    }

    public BitmapImagePixels(PdfImageXObject image) {
        this(Math.round(image.getWidth()), Math.round(image.getHeight()), BitmapImagePixels.obtainBitsPerComponent(image), BitmapImagePixels.obtainNumberOfComponents(image), ((PdfStream)image.getPdfObject()).getBytes());
    }

    public BitmapImagePixels(int width, int height, int bitsPerComponent, int numberOfComponents, byte[] data) {
        this.width = width;
        this.height = height;
        this.bitsPerComponent = bitsPerComponent;
        this.maxComponentValue = (1 << this.bitsPerComponent) - 1;
        this.numberOfComponents = numberOfComponents;
        int rowLength = width * bitsPerComponent * numberOfComponents;
        if (rowLength % 8 != 0) {
            rowLength += 8 - (rowLength & 7);
        }
        this.bitsInRow = rowLength;
        if (data == null) {
            this.data = new byte[this.bitsInRow * height >>> 3];
        } else {
            int expectedLength = this.bitsInRow * height;
            int actualLength = data.length * 8;
            if (expectedLength != actualLength) {
                throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid data length, expected length = {0}, actual length = {1}", (Object[])new Object[]{expectedLength, actualLength}));
            }
            this.data = Arrays.copyOf(data, data.length);
        }
    }

    public double[] getPixel(int x, int y) {
        long[] longArray = this.getPixelAsLongs(x, y);
        double[] pixelArray = new double[longArray.length];
        for (int i = 0; i < pixelArray.length; ++i) {
            pixelArray[i] = (double)longArray[i] / (double)this.maxComponentValue;
        }
        return pixelArray;
    }

    public long[] getPixelAsLongs(int x, int y) {
        this.checkCoordinates(x, y);
        long[] pixelArray = new long[this.numberOfComponents];
        for (int i = 0; i < pixelArray.length; ++i) {
            pixelArray[i] = this.readNumber(y * this.bitsInRow + x * this.bitsPerComponent * this.numberOfComponents + i * this.bitsPerComponent);
        }
        return pixelArray;
    }

    public void setPixel(int x, int y, double[] value) {
        long[] longArray = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            longArray[i] = Math.round(value[i] * (double)this.maxComponentValue);
        }
        this.setPixel(x, y, longArray);
    }

    public void setPixel(int x, int y, long[] value) {
        this.checkCoordinates(x, y);
        this.checkPixel(value);
        for (int i = 0; i < value.length; ++i) {
            this.writeNumber(value[i], y * this.bitsInRow + x * this.bitsPerComponent * this.numberOfComponents + i * this.bitsPerComponent);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getMaxComponentValue() {
        return this.maxComponentValue;
    }

    private long readNumber(int index) {
        long result = 0L;
        for (int i = 0; i < this.bitsPerComponent; ++i) {
            result = (result << 1) + (long)BitmapImagePixels.booleanToInt(this.getBit(index + i));
        }
        return result;
    }

    private void writeNumber(long number, int index) {
        for (int bitNumber = 0; bitNumber < this.bitsPerComponent; ++bitNumber) {
            int actualBitMask = 1 << this.bitsPerComponent - bitNumber - 1;
            this.setBit(index + bitNumber, (number & (long)actualBitMask) != 0L);
        }
    }

    private boolean getBit(int index) {
        return (this.data[index >>> 3] & 0xFF & 128 >>> (index & 7)) != 0;
    }

    private void setBit(int index, boolean value) {
        if (value) {
            int n = index >>> 3;
            this.data[n] = (byte)(this.data[n] | (byte)(128 >>> (index & 7)));
        } else {
            int n = index >>> 3;
            this.data[n] = (byte)(this.data[n] & (byte)(~(128 >>> (index & 7))));
        }
    }

    private void checkCoordinates(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y > this.height) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"Pixel ({0}, {1}) is out of borders of the image with parameter {2} x {3}", (Object[])new Object[]{x, y, this.width, this.height}));
        }
    }

    private void checkPixel(long[] pixel) {
        if (pixel.length != this.numberOfComponents) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"Length of pixel array ({0}) should match number of components ({1})", (Object[])new Object[]{pixel.length, this.numberOfComponents}));
        }
        for (int i = 0; i < pixel.length; ++i) {
            if (pixel[i] < 0L) {
                pixel[i] = 0L;
            }
            if (pixel[i] <= (long)this.maxComponentValue) continue;
            pixel[i] = this.maxComponentValue;
        }
    }

    private static int obtainBitsPerComponent(PdfImageXObject objectToProcess) {
        PdfStream imageStream = (PdfStream)objectToProcess.getPdfObject();
        PdfNumber bpc = imageStream.getAsNumber(PdfName.BitsPerComponent);
        if (bpc == null) {
            return 8;
        }
        return bpc.intValue();
    }

    private static int obtainNumberOfComponents(PdfImageXObject objectToProcess) {
        return PdfColorSpace.makeColorSpace(((PdfStream)objectToProcess.getPdfObject()).get(PdfName.ColorSpace)).getNumberOfComponents();
    }

    private static int booleanToInt(boolean value) {
        return value ? 1 : 0;
    }
}

