/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.validation;

import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.validation.IValidationChecker;
import com.itextpdf.kernel.validation.IValidationContext;
import java.util.ArrayList;
import java.util.List;

public class ValidationContainer {
    private final List<IValidationChecker> validationCheckers = new ArrayList<IValidationChecker>();

    public void validate(IValidationContext context) {
        for (IValidationChecker checker : this.validationCheckers) {
            checker.validate(context);
        }
    }

    public void addChecker(IValidationChecker checker) {
        this.validationCheckers.add(checker);
    }

    public boolean containsChecker(IValidationChecker checker) {
        return this.validationCheckers.contains(checker);
    }

    public boolean isPdfObjectChecked(PdfObject pdfObject) {
        for (IValidationChecker checker : this.validationCheckers) {
            if (checker.isPdfObjectReadyToFlush(pdfObject)) continue;
            return false;
        }
        return true;
    }
}

