/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.validation;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.Pdf20ConformanceException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.ITagTreeIteratorHandler;
import com.itextpdf.kernel.pdf.tagutils.PdfAllowedTagRelations;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIterator;
import com.itextpdf.kernel.utils.checkers.PdfCheckersUtil;
import com.itextpdf.kernel.validation.IValidationChecker;
import com.itextpdf.kernel.validation.IValidationContext;
import com.itextpdf.kernel.validation.context.PdfDocumentValidationContext;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import java.util.function.Function;

public class Pdf20Checker
implements IValidationChecker {
    private static final Function<String, PdfException> EXCEPTION_SUPPLIER = msg -> new Pdf20ConformanceException((String)msg);
    private static final PdfAllowedTagRelations allowedTagRelations = new PdfAllowedTagRelations();
    private final TagStructureContext tagStructureContext;

    public Pdf20Checker(PdfDocument pdfDocument) {
        this.tagStructureContext = pdfDocument.isTagged() ? pdfDocument.getTagStructureContext() : null;
    }

    @Override
    public void validate(IValidationContext validationContext) {
        switch (validationContext.getType()) {
            case PDF_DOCUMENT: {
                PdfDocumentValidationContext pdfDocContext = (PdfDocumentValidationContext)validationContext;
                this.checkCatalog(pdfDocContext.getPdfDocument().getCatalog());
                this.checkStructureTreeRoot(pdfDocContext.getPdfDocument().getStructTreeRoot());
            }
        }
    }

    @Override
    public boolean isPdfObjectReadyToFlush(PdfObject object) {
        return true;
    }

    void checkLang(PdfCatalog catalog) {
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        PdfObject lang = catalogDict.get(PdfName.Lang);
        if (lang instanceof PdfString && !((PdfString)lang).getValue().isEmpty()) {
            PdfCheckersUtil.validateLang(catalogDict, EXCEPTION_SUPPLIER);
        }
    }

    void checkMetadata(PdfCatalog catalog) {
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        if (!catalogDict.containsKey(PdfName.Metadata)) {
            return;
        }
        try {
            XMPMeta metadata = catalog.getDocument().getXmpMetadata();
            if (metadata == null) {
                throw new Pdf20ConformanceException("Document metadata value shall be a valid XMP metadata stream.");
            }
            PdfStream pdfStream = catalogDict.getAsStream(PdfName.Metadata);
            PdfName type = pdfStream.getAsName(PdfName.Type);
            PdfName subtype = pdfStream.getAsName(PdfName.Subtype);
            if (!PdfName.Metadata.equals(type) || !PdfName.XML.equals(subtype)) {
                throw new Pdf20ConformanceException("Document XMP metadata stream requires /Metadata type and /XML subtype.");
            }
        }
        catch (XMPException e) {
            throw new Pdf20ConformanceException("Document metadata value shall be a valid XMP metadata stream.", e);
        }
    }

    void checkStructureTreeRoot(PdfStructTreeRoot structTreeRoot) {
        if (this.tagStructureContext == null) {
            return;
        }
        TagTreeIterator tagTreeIterator = new TagTreeIterator(structTreeRoot);
        tagTreeIterator.addHandler(new StructureTreeRootHandler(this.tagStructureContext));
        tagTreeIterator.addHandler(new ParentChildRelationshipHandler(this.tagStructureContext));
        tagTreeIterator.traverse();
    }

    private void checkCatalog(PdfCatalog catalog) {
        this.checkLang(catalog);
        this.checkMetadata(catalog);
    }

    private static class StructureTreeRootHandler
    implements ITagTreeIteratorHandler {
        private final TagStructureContext tagStructureContext;

        public StructureTreeRootHandler(TagStructureContext tagStructureContext) {
            this.tagStructureContext = tagStructureContext;
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            PdfNamespace namespace;
            if (!(elem instanceof PdfStructElem)) {
                return;
            }
            PdfStructElem structElem = (PdfStructElem)elem;
            String role = structElem.getRole().getValue();
            if (!this.tagStructureContext.checkIfRoleShallBeMappedToStandardRole(role, namespace = structElem.getNamespace())) {
                throw new Pdf20ConformanceException(MessageFormatUtil.format((String)(namespace == null ? "Role \"{0}\" is not mapped to any standard role." : "Role \"{0}\" in namespace {1} is not mapped to any standard role."), (Object[])new Object[]{role, namespace != null ? namespace.getNamespaceName() : null}));
            }
        }
    }

    static final class ParentChildRelationshipHandler
    implements ITagTreeIteratorHandler {
        private final TagStructureContext tagStructureContext;

        public ParentChildRelationshipHandler(TagStructureContext context) {
            this.tagStructureContext = context;
        }

        private static void throwInvalidRelationshipException(String parentRole, String childRole) {
            throw new Pdf20ConformanceException(MessageFormatUtil.format((String)"Parent-child ({0}:{1}) relation is not allowed.", (Object[])new Object[]{parentRole, childRole}));
        }

        private String resolveRole(PdfStructElem elem) {
            IRoleMappingResolver parentResolver = this.tagStructureContext.resolveMappingToStandardOrDomainSpecificRole(elem.getRole().getValue(), elem.getNamespace());
            if (parentResolver == null || parentResolver.getNamespace() != null && "http://www.w3.org/1998/Math/MathML".equals(parentResolver.getNamespace().getNamespaceName())) {
                return null;
            }
            return parentResolver.getRole();
        }

        @Override
        public boolean accept(IStructureNode node) {
            return node != null;
        }

        @Override
        public void processElement(IStructureNode elem) {
            String parentRole;
            if (!(elem instanceof PdfStructElem) && !(elem instanceof PdfStructTreeRoot)) {
                return;
            }
            String string = parentRole = elem instanceof PdfStructElem ? this.resolveRole((PdfStructElem)elem) : PdfName.StructTreeRoot.getValue();
            if (parentRole == null) {
                return;
            }
            for (IStructureNode kid : elem.getKids()) {
                if (kid instanceof PdfStructTreeRoot) continue;
                if (kid instanceof PdfStructElem) {
                    String childRole = this.resolveRole((PdfStructElem)kid);
                    if (childRole == null || allowedTagRelations.isRelationAllowed(parentRole, childRole)) continue;
                    ParentChildRelationshipHandler.throwInvalidRelationshipException(parentRole, kid.getRole().getValue());
                    continue;
                }
                if (allowedTagRelations.isContentAllowedInRole(parentRole)) continue;
                ParentChildRelationshipHandler.throwInvalidRelationshipException(parentRole, "CONTENT");
            }
        }
    }
}

