/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfNumTree;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.validation.context.TagStructElementValidationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParentTreeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParentTreeHandler.class);
    private PdfStructTreeRoot structTreeRoot;
    private PdfNumTree parentTree;
    private Map<PdfIndirectReference, PageMcrsContainer> pageToPageMcrs;
    private Map<PdfIndirectReference, Integer> pageToStructParentsInd;
    private Map<PdfIndirectReference, Integer> xObjectToStructParentsInd;
    private int maxStructParentIndex = -1;

    ParentTreeHandler(PdfStructTreeRoot structTreeRoot) {
        this.structTreeRoot = structTreeRoot;
        this.parentTree = new PdfNumTree(structTreeRoot.getDocument().getCatalog(), PdfName.ParentTree);
        this.xObjectToStructParentsInd = new HashMap<PdfIndirectReference, Integer>();
        this.registerAllMcrs();
        this.pageToStructParentsInd = new HashMap<PdfIndirectReference, Integer>();
    }

    public PageMcrsContainer getPageMarkedContentReferences(PdfPage page) {
        return this.pageToPageMcrs.get(((PdfDictionary)page.getPdfObject()).getIndirectReference());
    }

    public PdfMcr findMcrByMcid(PdfDictionary pageDict, int mcid) {
        PageMcrsContainer pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        return pageMcrs != null ? (PdfMcr)pageMcrs.getPageContentStreamsMcrs().get(mcid) : null;
    }

    public PdfObjRef findObjRefByStructParentIndex(PdfDictionary pageDict, int structParentIndex) {
        PageMcrsContainer pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        return pageMcrs != null ? (PdfObjRef)pageMcrs.getObjRefs().get(structParentIndex) : null;
    }

    public int getNextMcidForPage(PdfPage page) {
        PageMcrsContainer pageMcrs = this.getPageMarkedContentReferences(page);
        if (pageMcrs == null || pageMcrs.getPageContentStreamsMcrs().size() == 0) {
            return 0;
        }
        return pageMcrs.getPageContentStreamsMcrs().lastEntry().getKey() + 1;
    }

    public void createParentTreeEntryForPage(PdfPage page) {
        PageMcrsContainer mcrs = this.getPageMarkedContentReferences(page);
        if (mcrs == null) {
            return;
        }
        this.pageToPageMcrs.remove(((PdfDictionary)page.getPdfObject()).getIndirectReference());
        if (this.updateStructParentTreeEntries(page, mcrs)) {
            this.structTreeRoot.setModified();
        }
    }

    public void savePageStructParentIndexIfNeeded(PdfPage page) {
        boolean hasNonObjRefMcr;
        PdfIndirectReference indRef = ((PdfDictionary)page.getPdfObject()).getIndirectReference();
        if (page.isFlushed() || this.pageToPageMcrs.get(indRef) == null) {
            return;
        }
        boolean bl = hasNonObjRefMcr = this.pageToPageMcrs.get(indRef).getPageContentStreamsMcrs().size() > 0 || this.pageToPageMcrs.get(indRef).getPageResourceXObjects().size() > 0;
        if (hasNonObjRefMcr) {
            this.pageToStructParentsInd.put(indRef, this.getOrCreatePageStructParentIndex(page));
        }
    }

    public PdfDictionary buildParentTree() {
        return (PdfDictionary)this.parentTree.buildTree().makeIndirect(this.structTreeRoot.getDocument());
    }

    public void registerMcr(PdfMcr mcr) {
        this.registerMcr(mcr, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerMcr(PdfMcr mcr, boolean registeringOnInit) {
        PdfObject stm;
        PdfIndirectReference mcrPageIndRef = mcr.getPageIndirectReference();
        if (mcrPageIndRef == null || !(mcr instanceof PdfObjRef) && mcr.getMcid() < 0) {
            LOGGER.error("Corrupted tag structure: encountered invalid marked content reference - it doesn't refer to any page or any mcid. This content reference will be ignored.");
            return;
        }
        PageMcrsContainer pageMcrs = this.pageToPageMcrs.get(mcrPageIndRef);
        if (pageMcrs == null) {
            pageMcrs = new PageMcrsContainer();
            this.pageToPageMcrs.put(mcrPageIndRef, pageMcrs);
        }
        if ((stm = ParentTreeHandler.getStm(mcr)) != null) {
            PdfStream xObjectStream;
            PdfIndirectReference stmIndRef;
            if (stm instanceof PdfIndirectReference) {
                stmIndRef = (PdfIndirectReference)stm;
                xObjectStream = (PdfStream)stmIndRef.getRefersTo();
            } else {
                if (stm.getIndirectReference() == null) {
                    stm.makeIndirect(this.structTreeRoot.getDocument());
                }
                stmIndRef = stm.getIndirectReference();
                xObjectStream = (PdfStream)stm;
            }
            Integer structParent = xObjectStream.getAsInt(PdfName.StructParents);
            if (structParent != null) {
                this.xObjectToStructParentsInd.put(stmIndRef, structParent);
                if (registeringOnInit) {
                    xObjectStream.release();
                }
            } else {
                if (!this.isModificationAllowed()) throw new PdfException("XObject has no StructParents index in its stream.");
                ++this.maxStructParentIndex;
                this.xObjectToStructParentsInd.put(stmIndRef, this.maxStructParentIndex);
                xObjectStream.put(PdfName.StructParents, new PdfNumber(this.maxStructParentIndex));
                ((PdfDictionary)this.structTreeRoot.getPdfObject()).put(PdfName.ParentTreeNextKey, new PdfNumber(this.maxStructParentIndex + 1));
                LOGGER.warn("XObject has no StructParents index in its stream, so index is recreated");
            }
            pageMcrs.putXObjectMcr(stmIndRef, mcr);
        } else if (mcr instanceof PdfObjRef) {
            PdfObject mcrObj = ((PdfDictionary)mcr.getPdfObject()).get(PdfName.Obj);
            if (!(mcrObj instanceof PdfDictionary)) {
                throw new PdfException("Object reference has unsupported type, supported types are dictionaries and streams");
            }
            PdfDictionary obj = (PdfDictionary)mcrObj;
            if (obj.isFlushed()) {
                throw new PdfException("When adding object reference to the tag tree, it must be connected to not flushed object.");
            }
            PdfNumber n = obj.getAsNumber(PdfName.StructParent);
            if (n != null) {
                pageMcrs.putObjectReferenceMcr(n.intValue(), mcr);
            } else {
                if (!this.isModificationAllowed()) throw new PdfException("StructParent index not found in tagged object.");
                ++this.maxStructParentIndex;
                pageMcrs.putObjectReferenceMcr(this.maxStructParentIndex, mcr);
                obj.put(PdfName.StructParent, new PdfNumber(this.maxStructParentIndex));
                ((PdfDictionary)this.structTreeRoot.getPdfObject()).put(PdfName.ParentTreeNextKey, new PdfNumber(this.maxStructParentIndex + 1));
                LOGGER.warn("StructParent index not found in tagged object, so index is recreated.");
            }
        } else {
            pageMcrs.putPageContentStreamMcr(mcr.getMcid(), mcr);
        }
        if (registeringOnInit) return;
        this.structTreeRoot.setModified();
    }

    public void unregisterMcr(PdfMcr mcrToUnregister) {
        PdfDictionary pageDict = mcrToUnregister.getPageObject();
        if (pageDict == null) {
            return;
        }
        if (pageDict.isFlushed()) {
            throw new PdfException("Cannot remove marked content reference, because its page has been already flushed.");
        }
        PageMcrsContainer pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        if (pageMcrs != null) {
            PdfObject stm = ParentTreeHandler.getStm(mcrToUnregister);
            if (stm != null) {
                PdfIndirectReference xObjectReference = stm instanceof PdfIndirectReference ? (PdfIndirectReference)stm : stm.getIndirectReference();
                pageMcrs.getPageResourceXObjects().get(xObjectReference).remove(mcrToUnregister.getMcid());
                if (pageMcrs.getPageResourceXObjects().get(xObjectReference).isEmpty()) {
                    pageMcrs.getPageResourceXObjects().remove(xObjectReference);
                    this.xObjectToStructParentsInd.remove(xObjectReference);
                }
                this.structTreeRoot.setModified();
            } else if (mcrToUnregister instanceof PdfObjRef) {
                for (Map.Entry<Integer, PdfMcr> entry : pageMcrs.getObjRefs().entrySet()) {
                    if (entry.getValue().getPdfObject() != mcrToUnregister.getPdfObject()) continue;
                    pageMcrs.getObjRefs().remove(entry.getKey());
                    this.structTreeRoot.setModified();
                    break;
                }
            } else {
                pageMcrs.getPageContentStreamsMcrs().remove(mcrToUnregister.getMcid());
                this.structTreeRoot.setModified();
            }
        }
    }

    private boolean isModificationAllowed() {
        PdfReader reader = this.structTreeRoot.getDocument().getReader();
        if (reader != null) {
            return PdfReader.StrictnessLevel.CONSERVATIVE.isStricter(reader.getStrictnessLevel());
        }
        return true;
    }

    private void registerAllMcrs() {
        this.pageToPageMcrs = new HashMap<PdfIndirectReference, PageMcrsContainer>();
        Map<Integer, PdfObject> parentTreeEntries = new PdfNumTree(this.structTreeRoot.getDocument().getCatalog(), PdfName.ParentTree).getNumbers();
        LinkedHashSet<PdfDictionary> mcrParents = new LinkedHashSet<PdfDictionary>();
        for (Map.Entry<Integer, PdfObject> entry : parentTreeEntries.entrySet()) {
            PdfObject entryValue;
            if (entry.getKey() > this.maxStructParentIndex) {
                this.maxStructParentIndex = entry.getKey();
            }
            if ((entryValue = entry.getValue()).isDictionary()) {
                mcrParents.add((PdfDictionary)entryValue);
                continue;
            }
            if (!entryValue.isArray()) continue;
            PdfArray parentsArray = (PdfArray)entryValue;
            for (int i = 0; i < parentsArray.size(); ++i) {
                PdfDictionary parent = parentsArray.getAsDictionary(i);
                if (parent == null) continue;
                mcrParents.add(parent);
            }
        }
        ((PdfDictionary)this.structTreeRoot.getPdfObject()).put(PdfName.ParentTreeNextKey, new PdfNumber(this.maxStructParentIndex + 1));
        for (PdfObject pdfObject : mcrParents) {
            PdfStructElem mcrParentStructElem = new PdfStructElem((PdfDictionary)pdfObject);
            for (IStructureNode kid : mcrParentStructElem.getKids()) {
                if (!(kid instanceof PdfMcr)) continue;
                this.registerMcr((PdfMcr)kid, true);
            }
        }
    }

    private boolean updateStructParentTreeEntries(PdfPage page, PageMcrsContainer mcrs) {
        int pageStructParentIndex;
        boolean res = false;
        for (Map.Entry<Integer, PdfMcr> entry : mcrs.getObjRefs().entrySet()) {
            PdfMcr pdfMcr = entry.getValue();
            PdfDictionary parentObj = (PdfDictionary)((PdfStructElem)pdfMcr.getParent()).getPdfObject();
            if (!parentObj.isIndirect()) continue;
            int structParent = (Integer)entry.getKey();
            this.parentTree.addEntry(structParent, parentObj);
            res = true;
        }
        for (Map.Entry entry : mcrs.getPageResourceXObjects().entrySet()) {
            PdfIndirectReference xObjectRef = (PdfIndirectReference)entry.getKey();
            if (!this.xObjectToStructParentsInd.containsKey(xObjectRef)) continue;
            int pageStructParentIndex2 = this.xObjectToStructParentsInd.remove(xObjectRef);
            if (!this.updateStructParentTreeForContentStreamEntries((Map)entry.getValue(), pageStructParentIndex2)) continue;
            res = true;
        }
        if (page.isFlushed()) {
            PdfIndirectReference pageRef = ((PdfDictionary)page.getPdfObject()).getIndirectReference();
            if (!this.pageToStructParentsInd.containsKey(pageRef)) {
                return res;
            }
            pageStructParentIndex = this.pageToStructParentsInd.remove(pageRef);
        } else {
            pageStructParentIndex = this.getOrCreatePageStructParentIndex(page);
        }
        if (this.updateStructParentTreeForContentStreamEntries(mcrs.getPageContentStreamsMcrs(), pageStructParentIndex)) {
            res = true;
        }
        return res;
    }

    private boolean updateStructParentTreeForContentStreamEntries(Map<Integer, PdfMcr> mcrsOfContentStream, int pageStructParentIndex) {
        PdfArray parentsOfMcrs = new PdfArray();
        int currentMcid = 0;
        for (Map.Entry<Integer, PdfMcr> entry : mcrsOfContentStream.entrySet()) {
            PdfMcr mcr = entry.getValue();
            PdfDictionary parentObj = (PdfDictionary)((PdfStructElem)mcr.getParent()).getPdfObject();
            if (!parentObj.isIndirect()) continue;
            while (currentMcid++ < mcr.getMcid()) {
                parentsOfMcrs.add(PdfNull.PDF_NULL);
            }
            parentsOfMcrs.add(parentObj);
        }
        if (!parentsOfMcrs.isEmpty()) {
            parentsOfMcrs.makeIndirect(this.structTreeRoot.getDocument());
            this.parentTree.addEntry(pageStructParentIndex, parentsOfMcrs);
            this.structTreeRoot.getDocument().checkIsoConformance(new TagStructElementValidationContext(parentsOfMcrs));
            parentsOfMcrs.flush();
            return true;
        }
        return false;
    }

    private int getOrCreatePageStructParentIndex(PdfPage page) {
        int structParentIndex = page.getStructParentIndex();
        if (structParentIndex < 0) {
            structParentIndex = page.getDocument().getNextStructParentIndex();
            ((PdfDictionary)page.getPdfObject()).put(PdfName.StructParents, new PdfNumber(structParentIndex));
        }
        return structParentIndex;
    }

    private static PdfObject getStm(PdfMcr mcr) {
        if (mcr instanceof PdfMcrDictionary) {
            return ((PdfDictionary)mcr.getPdfObject()).get(PdfName.Stm, false);
        }
        return null;
    }

    static class PageMcrsContainer {
        Map<Integer, PdfMcr> objRefs = new LinkedHashMap<Integer, PdfMcr>();
        NavigableMap<Integer, PdfMcr> pageContentStreams = new TreeMap<Integer, PdfMcr>();
        Map<PdfIndirectReference, TreeMap<Integer, PdfMcr>> pageResourceXObjects = new LinkedHashMap<PdfIndirectReference, TreeMap<Integer, PdfMcr>>();

        PageMcrsContainer() {
        }

        void putObjectReferenceMcr(int structParentIndex, PdfMcr mcr) {
            this.objRefs.put(structParentIndex, mcr);
        }

        void putPageContentStreamMcr(int mcid, PdfMcr mcr) {
            this.pageContentStreams.put(mcid, mcr);
        }

        void putXObjectMcr(PdfIndirectReference xObjectIndRef, PdfMcr mcr) {
            TreeMap<Integer, PdfMcr> xObjectMcrs = this.pageResourceXObjects.get(xObjectIndRef);
            if (xObjectMcrs == null) {
                xObjectMcrs = new TreeMap();
                this.pageResourceXObjects.put(xObjectIndRef, xObjectMcrs);
            }
            this.pageResourceXObjects.get(xObjectIndRef).put(mcr.getMcid(), mcr);
        }

        NavigableMap<Integer, PdfMcr> getPageContentStreamsMcrs() {
            return this.pageContentStreams;
        }

        Map<Integer, PdfMcr> getObjRefs() {
            return this.objRefs;
        }

        Map<PdfIndirectReference, TreeMap<Integer, PdfMcr>> getPageResourceXObjects() {
            return this.pageResourceXObjects;
        }

        Collection<PdfMcr> getAllMcrsAsCollection() {
            ArrayList<PdfMcr> collection = new ArrayList<PdfMcr>();
            collection.addAll(this.objRefs.values());
            collection.addAll(this.pageContentStreams.values());
            for (Map.Entry<PdfIndirectReference, TreeMap<Integer, PdfMcr>> entry : this.pageResourceXObjects.entrySet()) {
                collection.addAll(entry.getValue().values());
            }
            return collection;
        }
    }
}

