/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.filespec;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryptedPayload;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;

public class PdfEncryptedPayloadFileSpecFactory {
    public static PdfFileSpec create(PdfDocument doc, byte[] fileStore, PdfEncryptedPayload encryptedPayload, PdfName mimeType, PdfDictionary fileParameter) {
        return PdfEncryptedPayloadFileSpecFactory.addEncryptedPayloadDictionary(PdfFileSpec.createEmbeddedFileSpec(doc, fileStore, PdfEncryptedPayloadFileSpecFactory.generateDescription(encryptedPayload), PdfEncryptedPayloadFileSpecFactory.generateFileDisplay(encryptedPayload), mimeType, fileParameter, PdfName.EncryptedPayload), encryptedPayload);
    }

    public static PdfFileSpec create(PdfDocument doc, byte[] fileStore, PdfEncryptedPayload encryptedPayload, PdfDictionary fileParameter) {
        return PdfEncryptedPayloadFileSpecFactory.create(doc, fileStore, encryptedPayload, null, fileParameter);
    }

    public static PdfFileSpec create(PdfDocument doc, byte[] fileStore, PdfEncryptedPayload encryptedPayload) {
        return PdfEncryptedPayloadFileSpecFactory.create(doc, fileStore, encryptedPayload, null, null);
    }

    public static PdfFileSpec create(PdfDocument doc, String filePath, PdfEncryptedPayload encryptedPayload, PdfName mimeType, PdfDictionary fileParameter) throws IOException {
        return PdfEncryptedPayloadFileSpecFactory.addEncryptedPayloadDictionary(PdfFileSpec.createEmbeddedFileSpec(doc, filePath, PdfEncryptedPayloadFileSpecFactory.generateDescription(encryptedPayload), PdfEncryptedPayloadFileSpecFactory.generateFileDisplay(encryptedPayload), mimeType, fileParameter, PdfName.EncryptedPayload), encryptedPayload);
    }

    public static PdfFileSpec create(PdfDocument doc, String filePath, PdfEncryptedPayload encryptedPayload, PdfName mimeType) throws IOException {
        return PdfEncryptedPayloadFileSpecFactory.create(doc, filePath, encryptedPayload, mimeType, null);
    }

    public static PdfFileSpec create(PdfDocument doc, String filePath, PdfEncryptedPayload encryptedPayload) throws IOException {
        return PdfEncryptedPayloadFileSpecFactory.create(doc, filePath, encryptedPayload, null, null);
    }

    public static PdfFileSpec create(PdfDocument doc, InputStream is, PdfEncryptedPayload encryptedPayload, PdfName mimeType, PdfDictionary fileParameter) {
        return PdfEncryptedPayloadFileSpecFactory.addEncryptedPayloadDictionary(PdfFileSpec.createEmbeddedFileSpec(doc, is, PdfEncryptedPayloadFileSpecFactory.generateDescription(encryptedPayload), PdfEncryptedPayloadFileSpecFactory.generateFileDisplay(encryptedPayload), mimeType, fileParameter, PdfName.EncryptedPayload), encryptedPayload);
    }

    public static PdfFileSpec create(PdfDocument doc, InputStream is, PdfEncryptedPayload encryptedPayload, PdfName mimeType) {
        return PdfEncryptedPayloadFileSpecFactory.create(doc, is, encryptedPayload, mimeType, null);
    }

    public static PdfFileSpec create(PdfDocument doc, InputStream is, PdfEncryptedPayload encryptedPayload) {
        return PdfEncryptedPayloadFileSpecFactory.create(doc, is, encryptedPayload, null, null);
    }

    public static PdfFileSpec wrap(PdfDictionary dictionary) {
        PdfDictionary ef;
        if (!PdfName.EncryptedPayload.equals(dictionary.getAsName(PdfName.AFRelationship))) {
            LoggerFactory.getLogger(PdfEncryptedPayloadFileSpecFactory.class).error("Encrypted payload file spec shall have 'AFRelationship' filed equal to 'EncryptedPayload'");
        }
        if ((ef = dictionary.getAsDictionary(PdfName.EF)) == null || ef.getAsStream(PdfName.F) == null && ef.getAsStream(PdfName.UF) == null) {
            throw new PdfException("Encrypted payload file spec shall have 'EF' key. The value of such key shall be a dictionary that contains embedded file stream.");
        }
        if (!PdfName.Filespec.equals(dictionary.getAsName(PdfName.Type))) {
            throw new PdfException("Encrypted payload file spec shall have 'Type' key. The value of such key shall be 'Filespec'.");
        }
        if (!dictionary.isIndirect()) {
            throw new PdfException("Encrypted payload file spec shall be indirect.");
        }
        PdfFileSpec fileSpec = PdfFileSpec.wrapFileSpecObject(dictionary);
        if (PdfEncryptedPayload.extractFrom(fileSpec) == null) {
            throw new PdfException("Encrypted payload file spec shall have encrypted payload dictionary.");
        }
        return fileSpec;
    }

    public static String generateDescription(PdfEncryptedPayload ep) {
        String result = "This embedded file is encrypted using " + ep.getSubtype().getValue();
        PdfName version = ep.getVersion();
        if (version != null) {
            result = result + " , version: " + version.getValue();
        }
        return result;
    }

    public static String generateFileDisplay(PdfEncryptedPayload ep) {
        return ep.getSubtype().getValue() + "Protected.pdf";
    }

    private static PdfFileSpec addEncryptedPayloadDictionary(PdfFileSpec fs, PdfEncryptedPayload ep) {
        ((PdfDictionary)fs.getPdfObject()).put(PdfName.EP, (PdfObject)ep.getPdfObject());
        return fs;
    }
}

