/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import java.util.HashSet;
import java.util.Set;

class EncryptedEmbeddedStreamsHandler {
    private final PdfDocument document;
    private final Set<PdfStream> embeddedStreams = new HashSet<PdfStream>();

    EncryptedEmbeddedStreamsHandler(PdfDocument document) {
        this.document = document;
    }

    void storeAllEmbeddedStreams() {
        for (int i = 0; i < this.document.getNumberOfPdfObjects(); ++i) {
            PdfStream embeddedStream;
            PdfObject indirectObject = this.document.getPdfObject(i);
            if (!(indirectObject instanceof PdfDictionary) || (embeddedStream = EncryptedEmbeddedStreamsHandler.getEmbeddedFileStreamFromDictionary((PdfDictionary)indirectObject)) == null) continue;
            this.storeEmbeddedStream(embeddedStream);
        }
    }

    void storeEmbeddedStream(PdfStream embeddedStream) {
        this.embeddedStreams.add(embeddedStream);
    }

    boolean isStreamStoredAsEmbedded(PdfStream stream) {
        return this.embeddedStreams.contains(stream);
    }

    private static PdfStream getEmbeddedFileStreamFromDictionary(PdfDictionary dictionary) {
        PdfDictionary embeddedFileDictionary = dictionary.getAsDictionary(PdfName.EF);
        if (PdfName.Filespec.equals(dictionary.getAsName(PdfName.Type)) && embeddedFileDictionary != null) {
            return embeddedFileDictionary.getAsStream(PdfName.F);
        }
        return null;
    }
}

