/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import java.util.List;

final class AccessibilityPropertiesToStructElem {
    AccessibilityPropertiesToStructElem() {
    }

    static void apply(AccessibilityProperties properties, PdfStructElem elem) {
        AccessibilityPropertiesToStructElem.setTextualAids(properties, elem);
        AccessibilityPropertiesToStructElem.setAttributes(properties.getAttributesList(), elem);
        if (properties.getNamespace() != null) {
            elem.setNamespace(properties.getNamespace());
        }
        if (properties.getStructureElementId() != null) {
            elem.setStructureElementId(new PdfString(properties.getStructureElementId()));
        }
        for (TagTreePointer ref : properties.getRefsList()) {
            elem.addRef(ref.getCurrentStructElem());
        }
    }

    static PdfObject combineAttributesList(PdfObject attributesObject, int insertIndex, List<PdfStructureAttributes> newAttributesList, PdfNumber revision) {
        PdfArray combinedAttributes;
        if (attributesObject instanceof PdfDictionary) {
            PdfArray combinedAttributesArray = new PdfArray();
            combinedAttributesArray.add(attributesObject);
            AccessibilityPropertiesToStructElem.addNewAttributesToAttributesArray(insertIndex, newAttributesList, revision, combinedAttributesArray);
            combinedAttributes = combinedAttributesArray;
        } else if (attributesObject instanceof PdfArray) {
            PdfArray combinedAttributesArray = (PdfArray)attributesObject;
            AccessibilityPropertiesToStructElem.addNewAttributesToAttributesArray(insertIndex, newAttributesList, revision, combinedAttributesArray);
            combinedAttributes = combinedAttributesArray;
        } else if (newAttributesList.size() == 1) {
            if (insertIndex > 0) {
                throw new IndexOutOfBoundsException();
            }
            combinedAttributes = newAttributesList.get(0).getPdfObject();
        } else {
            combinedAttributes = new PdfArray();
            AccessibilityPropertiesToStructElem.addNewAttributesToAttributesArray(insertIndex, newAttributesList, revision, combinedAttributes);
        }
        return combinedAttributes;
    }

    private static void setAttributes(List<PdfStructureAttributes> newAttributesList, PdfStructElem elem) {
        if (newAttributesList.size() > 0) {
            PdfObject attributesObject = elem.getAttributes(false);
            PdfObject combinedAttributes = AccessibilityPropertiesToStructElem.combineAttributesList(attributesObject, -1, newAttributesList, ((PdfDictionary)elem.getPdfObject()).getAsNumber(PdfName.R));
            elem.setAttributes(combinedAttributes);
        }
    }

    private static void setTextualAids(AccessibilityProperties properties, PdfStructElem elem) {
        if (properties.getLanguage() != null) {
            elem.setLang(new PdfString(properties.getLanguage(), "UnicodeBig"));
        }
        if (properties.getActualText() != null) {
            elem.setActualText(new PdfString(properties.getActualText(), "UnicodeBig"));
        }
        if (properties.getAlternateDescription() != null) {
            elem.setAlt(new PdfString(properties.getAlternateDescription(), "UnicodeBig"));
        }
        if (properties.getExpansion() != null) {
            elem.setE(new PdfString(properties.getExpansion(), "UnicodeBig"));
        }
        if (properties.getPhoneme() != null) {
            elem.setPhoneme(new PdfString(properties.getPhoneme(), "UnicodeBig"));
        }
        if (properties.getPhoneticAlphabet() != null) {
            elem.setPhoneticAlphabet(new PdfName(properties.getPhoneticAlphabet()));
        }
    }

    private static void addNewAttributesToAttributesArray(int insertIndex, List<PdfStructureAttributes> newAttributesList, PdfNumber revision, PdfArray attributesArray) {
        if (insertIndex < 0) {
            insertIndex = attributesArray.size();
        }
        if (revision != null) {
            for (PdfStructureAttributes attributes : newAttributesList) {
                attributesArray.add(insertIndex++, (PdfObject)attributes.getPdfObject());
                attributesArray.add(insertIndex++, revision);
            }
        } else {
            for (PdfStructureAttributes newAttribute : newAttributesList) {
                attributesArray.add(insertIndex++, (PdfObject)newAttribute.getPdfObject());
            }
        }
    }
}

