/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.xmp;

import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPSchemaRegistry;
import com.itextpdf.kernel.xmp.XMPVersionInfo;
import com.itextpdf.kernel.xmp.impl.XMPMetaImpl;
import com.itextpdf.kernel.xmp.impl.XMPMetaParser;
import com.itextpdf.kernel.xmp.impl.XMPSchemaRegistryImpl;
import com.itextpdf.kernel.xmp.impl.XMPSerializerHelper;
import com.itextpdf.kernel.xmp.options.ParseOptions;
import com.itextpdf.kernel.xmp.options.SerializeOptions;
import java.io.InputStream;
import java.io.OutputStream;

public final class XMPMetaFactory {
    private static final Object staticLock = new Object();
    private static XMPSchemaRegistry schema = new XMPSchemaRegistryImpl();
    private static XMPVersionInfo versionInfo = null;

    private XMPMetaFactory() {
    }

    public static XMPSchemaRegistry getSchemaRegistry() {
        return schema;
    }

    public static XMPMeta create() {
        return new XMPMetaImpl();
    }

    public static XMPMeta parse(InputStream in) throws XMPException {
        return XMPMetaFactory.parse(in, null);
    }

    public static XMPMeta parse(InputStream in, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse(in, options);
    }

    public static XMPMeta parseFromString(String packet) throws XMPException {
        return XMPMetaFactory.parseFromString(packet, null);
    }

    public static XMPMeta parseFromString(String packet, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse(packet, options);
    }

    public static XMPMeta parseFromBuffer(byte[] buffer) throws XMPException {
        return XMPMetaFactory.parseFromBuffer(buffer, null);
    }

    public static XMPMeta parseFromBuffer(byte[] buffer, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse(buffer, options);
    }

    public static void serialize(XMPMeta xmp, OutputStream out) throws XMPException {
        XMPMetaFactory.serialize(xmp, out, null);
    }

    public static void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        XMPSerializerHelper.serialize((XMPMetaImpl)xmp, out, options);
    }

    public static byte[] serializeToBuffer(XMPMeta xmp, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        return XMPSerializerHelper.serializeToBuffer((XMPMetaImpl)xmp, options);
    }

    public static String serializeToString(XMPMeta xmp, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        return XMPSerializerHelper.serializeToString((XMPMetaImpl)xmp, options);
    }

    private static void assertImplementation(XMPMeta xmp) {
        if (!(xmp instanceof XMPMetaImpl)) {
            throw new UnsupportedOperationException("The serializing service works onlywith the XMPMeta implementation of this library");
        }
    }

    public static void reset() {
        schema = new XMPSchemaRegistryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMPVersionInfo getVersionInfo() {
        Object object = staticLock;
        synchronized (object) {
            if (versionInfo == null) {
                try {
                    int major = 5;
                    boolean minor = true;
                    boolean micro = false;
                    int engBuild = 3;
                    boolean debug = false;
                    String message = "Adobe XMP Core 5.1.0-jc003";
                    versionInfo = new XMPVersionInfo(){

                        @Override
                        public int getMajor() {
                            return 5;
                        }

                        @Override
                        public int getMinor() {
                            return 1;
                        }

                        @Override
                        public int getMicro() {
                            return 0;
                        }

                        @Override
                        public boolean isDebug() {
                            return false;
                        }

                        @Override
                        public int getBuild() {
                            return 3;
                        }

                        @Override
                        public String getMessage() {
                            return "Adobe XMP Core 5.1.0-jc003";
                        }

                        public String toString() {
                            return "Adobe XMP Core 5.1.0-jc003";
                        }
                    };
                }
                catch (Throwable e) {
                    System.out.println(e);
                }
            }
            return versionInfo;
        }
    }
}

