/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.BorderStyleUtil;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.da.AnnotationDefaultAppearance;

public class PdfFreeTextAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -7835504102518915220L;
    public static final int LEFT_JUSTIFIED = 0;
    public static final int CENTERED = 1;
    public static final int RIGHT_JUSTIFIED = 2;

    public PdfFreeTextAnnotation(Rectangle rect, PdfString contents) {
        super(rect);
        this.setContents(contents);
    }

    @Deprecated
    public PdfFreeTextAnnotation(Rectangle rect, String appearanceString) {
        super(rect);
        this.setDefaultAppearance(new PdfString(appearanceString));
    }

    @Deprecated
    public PdfFreeTextAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.FreeText;
    }

    public PdfString getDefaultStyleString() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DS);
    }

    public PdfFreeTextAnnotation setDefaultStyleString(PdfString defaultStyleString) {
        return (PdfFreeTextAnnotation)this.put(PdfName.DS, defaultStyleString);
    }

    @Override
    public PdfString getDefaultAppearance() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
    }

    @Override
    public PdfFreeTextAnnotation setDefaultAppearance(PdfString appearanceString) {
        return (PdfFreeTextAnnotation)this.put(PdfName.DA, appearanceString);
    }

    public PdfFreeTextAnnotation setDefaultAppearance(AnnotationDefaultAppearance da) {
        return this.setDefaultAppearance(da.toPdfString());
    }

    public PdfArray getCalloutLine() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CL);
    }

    public PdfFreeTextAnnotation setCalloutLine(float[] calloutLine) {
        return this.setCalloutLine(new PdfArray(calloutLine));
    }

    public PdfFreeTextAnnotation setCalloutLine(PdfArray calloutLine) {
        return (PdfFreeTextAnnotation)this.put(PdfName.CL, calloutLine);
    }

    public PdfName getLineEndingStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.LE);
    }

    public PdfFreeTextAnnotation setLineEndingStyle(PdfName lineEndingStyle) {
        return (PdfFreeTextAnnotation)this.put(PdfName.LE, lineEndingStyle);
    }

    @Override
    public int getJustification() {
        PdfNumber q = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Q);
        return q == null ? 0 : q.intValue();
    }

    @Override
    public PdfFreeTextAnnotation setJustification(int justification) {
        return (PdfFreeTextAnnotation)this.put(PdfName.Q, new PdfNumber(justification));
    }

    @Override
    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    @Override
    public PdfFreeTextAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return (PdfFreeTextAnnotation)this.put(PdfName.BS, borderStyle);
    }

    @Override
    public PdfFreeTextAnnotation setBorderStyle(PdfName style) {
        return this.setBorderStyle(BorderStyleUtil.setStyle(this.getBorderStyle(), style));
    }

    @Override
    public PdfFreeTextAnnotation setDashPattern(PdfArray dashPattern) {
        return this.setBorderStyle(BorderStyleUtil.setDashPattern(this.getBorderStyle(), dashPattern));
    }

    @Override
    public PdfArray getRectangleDifferences() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.RD);
    }

    @Override
    public PdfFreeTextAnnotation setRectangleDifferences(PdfArray rect) {
        return (PdfFreeTextAnnotation)this.put(PdfName.RD, rect);
    }

    @Override
    public PdfDictionary getBorderEffect() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BE);
    }

    @Override
    public PdfFreeTextAnnotation setBorderEffect(PdfDictionary borderEffect) {
        return (PdfFreeTextAnnotation)this.put(PdfName.BE, borderEffect);
    }
}

