/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfObject;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfPrimitiveObject
extends PdfObject {
    private static final long serialVersionUID = -1788064882121987538L;
    protected byte[] content = null;
    protected boolean directOnly;

    protected PdfPrimitiveObject() {
    }

    protected PdfPrimitiveObject(boolean directOnly) {
        this.directOnly = directOnly;
    }

    protected PdfPrimitiveObject(byte[] content) {
        this();
        assert (content != null);
        this.content = content;
    }

    protected final byte[] getInternalContent() {
        if (this.content == null) {
            this.generateContent();
        }
        return this.content;
    }

    protected boolean hasContent() {
        return this.content != null;
    }

    protected abstract void generateContent();

    @Override
    public PdfObject makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        if (!this.directOnly) {
            return super.makeIndirect(document, reference);
        }
        Logger logger = LoggerFactory.getLogger(PdfObject.class);
        logger.warn("DirectOnly object cannot be indirect");
        return this;
    }

    @Override
    public PdfObject setIndirectReference(PdfIndirectReference indirectReference) {
        if (!this.directOnly) {
            super.setIndirectReference(indirectReference);
        } else {
            Logger logger = LoggerFactory.getLogger(PdfObject.class);
            logger.warn("DirectOnly object cannot be indirect");
        }
        return this;
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfPrimitiveObject object = (PdfPrimitiveObject)from;
        if (object.content != null) {
            this.content = Arrays.copyOf(object.content, object.content.length);
        }
    }

    protected int compareContent(PdfPrimitiveObject o) {
        for (int i = 0; i < Math.min(this.content.length, o.content.length); ++i) {
            if (this.content[i] > o.content[i]) {
                return 1;
            }
            if (this.content[i] >= o.content[i]) continue;
            return -1;
        }
        return Integer.compare(this.content.length, o.content.length);
    }
}

