/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.richmedia;

import com.itextpdf.text.Rectangle;
import com.itextpdf.text.exceptions.IllegalPdfSyntaxException;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDeveloperExtension;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNameTree;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.richmedia.RichMediaActivation;
import com.itextpdf.text.pdf.richmedia.RichMediaConfiguration;
import com.itextpdf.text.pdf.richmedia.RichMediaDeactivation;
import java.io.IOException;
import java.util.HashMap;

public class RichMediaAnnotation {
    protected PdfWriter writer;
    protected PdfAnnotation annot;
    protected PdfDictionary richMediaContent = null;
    protected PdfIndirectReference richMediaContentReference = null;
    protected PdfDictionary richMediaSettings = new PdfDictionary(PdfName.RICHMEDIASETTINGS);
    protected HashMap<String, PdfIndirectReference> assetsmap = null;
    protected PdfArray configurations = null;
    protected PdfArray views = null;

    public RichMediaAnnotation(PdfWriter writer, Rectangle rect) {
        this.writer = writer;
        this.annot = new PdfAnnotation(writer, rect);
        this.annot.put(PdfName.SUBTYPE, (PdfObject)PdfName.RICHMEDIA);
        this.richMediaContent = new PdfDictionary(PdfName.RICHMEDIACONTENT);
        this.assetsmap = new HashMap();
        this.configurations = new PdfArray();
        this.views = new PdfArray();
    }

    public RichMediaAnnotation(PdfWriter writer, Rectangle rect, PdfIndirectReference richMediaContentReference) {
        this.richMediaContentReference = richMediaContentReference;
        this.richMediaContent = null;
        this.writer = writer;
        this.annot = new PdfAnnotation(writer, rect);
        this.annot.put(PdfName.SUBTYPE, (PdfObject)PdfName.RICHMEDIA);
    }

    public PdfIndirectReference getRichMediaContentReference() {
        return this.richMediaContentReference;
    }

    public PdfIndirectReference addAsset(String name, PdfFileSpecification fs) throws IOException {
        if (this.assetsmap == null) {
            throw new IllegalPdfSyntaxException("You can't add assets to reused RichMediaContent.");
        }
        PdfIndirectReference ref = this.writer.addToBody((PdfObject)fs).getIndirectReference();
        this.assetsmap.put(name, ref);
        return ref;
    }

    public PdfIndirectReference addAsset(String name, PdfIndirectReference ref) throws IOException {
        if (this.views == null) {
            throw new IllegalPdfSyntaxException("You can't add assets to reused RichMediaContent.");
        }
        this.assetsmap.put(name, ref);
        return ref;
    }

    public PdfIndirectReference addConfiguration(RichMediaConfiguration configuration) throws IOException {
        if (this.configurations == null) {
            throw new IllegalPdfSyntaxException("You can't add configurations to reused RichMediaContent.");
        }
        PdfIndirectReference ref = this.writer.addToBody((PdfObject)configuration).getIndirectReference();
        this.configurations.add((PdfObject)ref);
        return ref;
    }

    public PdfIndirectReference addConfiguration(PdfIndirectReference ref) throws IOException {
        if (this.configurations == null) {
            throw new IllegalPdfSyntaxException("You can't add configurations to reused RichMediaContent.");
        }
        this.configurations.add((PdfObject)ref);
        return ref;
    }

    public PdfIndirectReference addView(PdfDictionary view) throws IOException {
        if (this.views == null) {
            throw new IllegalPdfSyntaxException("You can't add views to reused RichMediaContent.");
        }
        PdfIndirectReference ref = this.writer.addToBody((PdfObject)view).getIndirectReference();
        this.views.add((PdfObject)ref);
        return ref;
    }

    public PdfIndirectReference addView(PdfIndirectReference ref) throws IOException {
        if (this.views == null) {
            throw new IllegalPdfSyntaxException("You can't add views to reused RichMediaContent.");
        }
        this.views.add((PdfObject)ref);
        return ref;
    }

    public void setActivation(RichMediaActivation richMediaActivation) {
        this.richMediaSettings.put(PdfName.ACTIVATION, (PdfObject)richMediaActivation);
    }

    public void setDeactivation(RichMediaDeactivation richMediaDeactivation) {
        this.richMediaSettings.put(PdfName.DEACTIVATION, (PdfObject)richMediaDeactivation);
    }

    public PdfAnnotation createAnnotation() throws IOException {
        if (this.richMediaContent != null) {
            if (!this.assetsmap.isEmpty()) {
                PdfDictionary assets = PdfNameTree.writeTree(this.assetsmap, (PdfWriter)this.writer);
                this.richMediaContent.put(PdfName.ASSETS, (PdfObject)this.writer.addToBody((PdfObject)assets).getIndirectReference());
            }
            if (this.configurations.size() > 0) {
                this.richMediaContent.put(PdfName.CONFIGURATION, (PdfObject)this.writer.addToBody((PdfObject)this.configurations).getIndirectReference());
            }
            if (this.views.size() > 0) {
                this.richMediaContent.put(PdfName.VIEWS, (PdfObject)this.writer.addToBody((PdfObject)this.views).getIndirectReference());
            }
            this.richMediaContentReference = this.writer.addToBody((PdfObject)this.richMediaContent).getIndirectReference();
        }
        this.writer.addDeveloperExtension(PdfDeveloperExtension.ADOBE_1_7_EXTENSIONLEVEL3);
        this.annot.put(PdfName.RICHMEDIACONTENT, (PdfObject)this.richMediaContentReference);
        this.annot.put(PdfName.RICHMEDIASETTINGS, (PdfObject)this.writer.addToBody((PdfObject)this.richMediaSettings).getIndirectReference());
        return this.annot;
    }
}

