/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.util;

import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfResourceCounter {
    protected Map<Integer, PdfObject> resources = new HashMap<Integer, PdfObject>();

    public PdfResourceCounter(PdfObject object) {
        this.process(object);
    }

    protected final void process(PdfObject object) {
        PRIndirectReference ref = object.getIndRef();
        if (ref == null || this.resources.put(ref.getNumber(), object) == null) {
            this.loopOver(object);
        }
    }

    protected final void loopOver(PdfObject object) {
        switch (object.type()) {
            case 5: {
                PdfArray array = (PdfArray)object;
                for (int i = 0; i < array.size(); ++i) {
                    this.process(array.getDirectObject(i));
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary dict = (PdfDictionary)object;
                if (dict.isPages()) break;
                for (PdfName name : dict.getKeys()) {
                    this.process(dict.getDirectObject(name));
                }
                break;
            }
        }
    }

    public Map<Integer, PdfObject> getResources() {
        return this.resources;
    }

    public long getLength(Map<Integer, PdfObject> res) throws IOException {
        long length = 0L;
        for (int ref : this.resources.keySet()) {
            if (res != null && res.containsKey(ref)) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfObject object = this.resources.get(ref);
            object.toPdf(null, (OutputStream)baos);
            length += (long)baos.size();
        }
        return length;
    }
}

