/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.mc;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.exceptions.InvalidPdfException;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfNumberTree;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.mc.StructureItem;
import com.itextpdf.text.pdf.mc.StructureMCID;
import com.itextpdf.text.pdf.mc.StructureObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureItems
extends ArrayList<StructureItem> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StructureItems.class);
    protected PdfDictionary structTreeRoot;
    protected HashMap<Integer, PdfObject> parentTree;
    private static final long serialVersionUID = -8247348202717165564L;

    public StructureItems(PdfReader reader) throws DocumentException, InvalidPdfException {
        PdfDictionary catalog = reader.getCatalog();
        this.structTreeRoot = catalog.getAsDict(PdfName.STRUCTTREEROOT);
        if (this.structTreeRoot == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage((String)"can.t.read.document.structure", (Object[])new Object[0]));
        }
        this.parentTree = PdfNumberTree.readTree((PdfDictionary)this.structTreeRoot.getAsDict(PdfName.PARENTTREE));
        this.structTreeRoot.remove(PdfName.STRUCTPARENTS);
        PdfObject object = this.structTreeRoot.getDirectObject(PdfName.K);
        if (object == null) {
            return;
        }
        switch (object.type()) {
            case 6: {
                LOGGER.info("StructTreeRoot refers to dictionary");
                this.processStructElems((PdfDictionary)object, this.structTreeRoot.getAsIndirectObject(PdfName.K));
                break;
            }
            case 5: {
                LOGGER.info("StructTreeRoot refers to array");
                PdfArray array = (PdfArray)object;
                for (int i = 0; i < array.size(); ++i) {
                    this.processStructElems(array.getAsDict(i), array.getAsIndirectObject(i));
                }
                break;
            }
        }
    }

    protected void processStructElems(PdfDictionary structElem, PdfIndirectReference ref) throws InvalidPdfException {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info(String.format("addStructureItems(%s, %s)", structElem, ref));
        }
        if (structElem == null) {
            return;
        }
        this.processStructElemKids(structElem, ref, structElem.getDirectObject(PdfName.K));
    }

    protected void processStructElemKids(PdfDictionary structElem, PdfIndirectReference ref, PdfObject object) throws InvalidPdfException {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info(String.format("addStructureItem(%s, %s, %s)", structElem, ref, object));
        }
        if (object == null) {
            return;
        }
        switch (object.type()) {
            case 2: {
                StructureMCID item = new StructureMCID(structElem.getAsIndirectObject(PdfName.PG), (PdfNumber)object);
                this.add(item);
                LOGGER.info("Added " + item);
                break;
            }
            case 5: {
                PdfArray array = (PdfArray)object;
                for (int i = 0; i < array.size(); ++i) {
                    this.processStructElemKids(structElem, array.getAsIndirectObject(i), array.getDirectObject(i));
                }
                break;
            }
            case 6: {
                PdfDictionary dict = (PdfDictionary)object;
                if (dict.checkType(PdfName.MCR)) {
                    StructureMCID item = new StructureMCID(dict);
                    this.add(item);
                    LOGGER.info("Added " + item);
                    break;
                }
                if (dict.checkType(PdfName.OBJR)) {
                    StructureObject item = new StructureObject(structElem, ref, dict);
                    this.add(item);
                    LOGGER.info("Added " + item);
                    break;
                }
                this.processStructElems(dict, ref);
            }
        }
    }

    public void removeFromParentTree(PdfNumber structParent) {
        this.parentTree.remove(structParent.intValue());
    }

    public int processMCID(PdfNumber structParents, PdfIndirectReference ref) throws DocumentException {
        if (ref == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage((String)"can.t.read.document.structure", (Object[])new Object[0]));
        }
        PdfObject object = this.parentTree.get(structParents.intValue());
        PdfArray array = (PdfArray)PdfReader.getPdfObject((PdfObject)object);
        int i = this.getNextMCID(structParents);
        if (i < array.size()) {
            array.set(i, (PdfObject)ref);
            return i;
        }
        array.add((PdfObject)ref);
        return array.size() - 1;
    }

    public int getNextMCID(PdfNumber structParents) {
        PdfObject object = this.parentTree.get(structParents.intValue());
        PdfArray array = (PdfArray)PdfReader.getPdfObject((PdfObject)object);
        for (int i = 0; i < array.size(); ++i) {
            if (array.getAsIndirectObject(i) != null) continue;
            return i;
        }
        return array.size();
    }

    public void writeParentTree(PdfWriter writer) throws IOException {
        if (this.structTreeRoot == null) {
            return;
        }
        Object[] numbers = new Integer[this.parentTree.size()];
        numbers = this.parentTree.keySet().toArray(numbers);
        Arrays.sort(numbers);
        this.structTreeRoot.put(PdfName.PARENTTREENEXTKEY, (PdfObject)new PdfNumber((Integer)numbers[numbers.length - 1] + 1));
        this.structTreeRoot.put(PdfName.PARENTTREE, (PdfObject)PdfNumberTree.writeTree(this.parentTree, (PdfWriter)writer));
    }
}

