/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

class PdfCleanUpContext {
    private PdfDictionary resources;
    private PdfContentByte canvas;
    private Stack<List<PdfObject>> strokeColorOperands;

    public PdfCleanUpContext() {
        ArrayList<PdfObject> initialStrokeColor = new ArrayList<PdfObject>(Arrays.asList(PdfName.DEVICEGRAY, new PdfLiteral("CS")));
        this.strokeColorOperands = new Stack();
        this.strokeColorOperands.push(initialStrokeColor);
    }

    public PdfCleanUpContext(PdfDictionary resources, PdfContentByte canvas) {
        this();
        this.resources = resources;
        this.canvas = canvas;
    }

    public PdfDictionary getResources() {
        return this.resources;
    }

    public void setResources(PdfDictionary resources) {
        this.resources = resources;
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte canvas) {
        this.canvas = canvas;
    }

    public void pushStrokeColor(List<PdfObject> strokeColorOperands) {
        this.strokeColorOperands.push(new ArrayList<PdfObject>(strokeColorOperands));
    }

    public List<PdfObject> peekStrokeColor() {
        if (this.strokeColorOperands.size() == 0) {
            return null;
        }
        return this.strokeColorOperands.peek();
    }

    public List<PdfObject> popStrokeColor() {
        return this.strokeColorOperands.pop();
    }
}

