/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfWriter;

public abstract class PdfAChecker {
    protected PdfAConformanceLevel conformanceLevel;

    PdfAChecker(PdfAConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
    }

    protected abstract void checkFont(PdfWriter var1, int var2, Object var3);

    protected abstract void checkImage(PdfWriter var1, int var2, Object var3);

    protected abstract void checkGState(PdfWriter var1, int var2, Object var3);

    protected abstract void checkLayer(PdfWriter var1, int var2, Object var3);

    protected abstract void checkTrailer(PdfWriter var1, int var2, Object var3);

    protected abstract void checkStream(PdfWriter var1, int var2, Object var3);

    protected abstract void checkFileSpec(PdfWriter var1, int var2, Object var3);

    protected abstract void checkPdfObject(PdfWriter var1, int var2, Object var3);

    protected abstract void checkCanvas(PdfWriter var1, int var2, Object var3);

    protected abstract void checkColor(PdfWriter var1, int var2, Object var3);

    protected abstract void checkAnnotation(PdfWriter var1, int var2, Object var3);

    protected abstract void checkAction(PdfWriter var1, int var2, Object var3);

    protected abstract void checkForm(PdfWriter var1, int var2, Object var3);

    protected abstract void checkStructElem(PdfWriter var1, int var2, Object var3);

    void checkPdfAConformance(PdfWriter writer, int key, Object obj1) {
        if (writer == null || !writer.isPdfIso()) {
            return;
        }
        switch (key) {
            case 4: {
                this.checkFont(writer, key, obj1);
                break;
            }
            case 5: {
                this.checkImage(writer, key, obj1);
                break;
            }
            case 6: {
                this.checkGState(writer, key, obj1);
                break;
            }
            case 7: {
                this.checkLayer(writer, key, obj1);
                break;
            }
            case 8: {
                this.checkTrailer(writer, key, obj1);
                break;
            }
            case 9: {
                this.checkStream(writer, key, obj1);
                break;
            }
            case 10: {
                this.checkFileSpec(writer, key, obj1);
                break;
            }
            case 11: {
                this.checkPdfObject(writer, key, obj1);
                break;
            }
            case 12: {
                this.checkCanvas(writer, key, obj1);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.checkColor(writer, key, obj1);
                break;
            }
            case 13: {
                this.checkAnnotation(writer, key, obj1);
                break;
            }
            case 14: {
                this.checkAction(writer, key, obj1);
                break;
            }
            case 15: {
                this.checkForm(writer, key, obj1);
                break;
            }
            case 16: {
                if (!PdfAChecker.checkStructure(this.conformanceLevel)) break;
                this.checkStructElem(writer, key, obj1);
                break;
            }
        }
    }

    public static boolean checkStructure(PdfAConformanceLevel conformanceLevel) {
        return conformanceLevel == PdfAConformanceLevel.PDF_A_1A || conformanceLevel == PdfAConformanceLevel.PDF_A_2A || conformanceLevel == PdfAConformanceLevel.PDF_A_3A;
    }
}

