/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.Jpeg2000;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfImage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfOCG;
import com.itextpdf.text.pdf.PdfOCProperties;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.internal.PdfA1Checker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfA2Checker
extends PdfA1Checker {
    private static HashSet<PdfName> allowedBlendModes = new HashSet<PdfName>(Arrays.asList(PdfGState.BM_NORMAL, PdfGState.BM_COMPATIBLE, PdfGState.BM_MULTIPLY, PdfGState.BM_SCREEN, PdfGState.BM_OVERLAY, PdfGState.BM_DARKEN, PdfGState.BM_LIGHTEN, PdfGState.BM_COLORDODGE, PdfGState.BM_COLORBURN, PdfGState.BM_HARDLIGHT, PdfGState.BM_SOFTLIGHT, PdfGState.BM_DIFFERENCE, PdfGState.BM_EXCLUSION));

    PdfA2Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    protected void checkGState(PdfWriter writer, int key, Object obj1) {
        PdfDictionary gs = (PdfDictionary)obj1;
        PdfObject obj = gs.get(PdfName.BM);
        if (obj != null && !allowedBlendModes.contains(obj)) {
            throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"blend.mode.1.not.allowed", (Object[])new Object[]{obj.toString()}));
        }
    }

    @Override
    protected void checkImage(PdfWriter writer, int key, Object obj1) {
        PdfImage pdfImage = (PdfImage)obj1;
        if (pdfImage != null && pdfImage.getImage() instanceof Jpeg2000) {
            Jpeg2000 jpeg2000 = (Jpeg2000)pdfImage.getImage();
            if (!jpeg2000.isJp2()) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"only.jpx.baseline.set.of.features.shall.be.used", (Object[])new Object[0]));
            }
            if (jpeg2000.getNumOfComps() != 1 && jpeg2000.getNumOfComps() != 3 && jpeg2000.getNumOfComps() != 4) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.number.of.colour.channels.in.the.jpeg2000.data.shall.be.123", (Object[])new Object[0]));
            }
            if (jpeg2000.getBpc() < 1 || jpeg2000.getBpc() > 38) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.bit-depth.of.the.jpeg2000.data.shall.have.a.value.in.the.range.1to38", (Object[])new Object[0]));
            }
            if (jpeg2000.getBpcBoxData() != null) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"all.colour.channels.in.the.jpeg2000.data.shall.have.the.same.bit-depth", (Object[])new Object[0]));
            }
            ArrayList colorSpecBoxes = jpeg2000.getColorSpecBoxes();
            if (colorSpecBoxes != null) {
                if (colorSpecBoxes.size() > 1) {
                    int approx0x01 = 0;
                    for (Jpeg2000.ColorSpecBox colorSpecBox : colorSpecBoxes) {
                        if (colorSpecBox.getApprox() != 1) continue;
                        ++approx0x01;
                    }
                    if (approx0x01 != 1) {
                        throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"exactly.one.colour.space.specification.shall.have.the.value.0x01.in.the.approx.field", (Object[])new Object[0]));
                    }
                }
                for (Jpeg2000.ColorSpecBox colorSpecBox : colorSpecBoxes) {
                    if (colorSpecBox.getMeth() != 1 && colorSpecBox.getMeth() != 2 && colorSpecBox.getMeth() != 3) {
                        throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.value.of.the.meth.entry.in.colr.box.shall.be.123", (Object[])new Object[0]));
                    }
                    if (colorSpecBox.getEnumCs() == 19) {
                        throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"jpeg2000.enumerated.colour.space.19.(CIEJab).shall.not.be.used", (Object[])new Object[0]));
                    }
                    byte[] colorProfileBytes = colorSpecBox.getColorProfile();
                    if (colorProfileBytes == null) continue;
                }
            }
        }
    }

    @Override
    protected void checkLayer(PdfWriter writer, int key, Object obj1) {
        if (!(obj1 instanceof PdfOCG) && obj1 instanceof PdfOCProperties) {
            PdfArray configs;
            PdfOCProperties properties = (PdfOCProperties)obj1;
            ArrayList<PdfDictionary> configsList = new ArrayList<PdfDictionary>();
            PdfDictionary d = properties.getAsDict(PdfName.D);
            if (d != null) {
                configsList.add(d);
            }
            if ((configs = properties.getAsArray(PdfName.CONFIGS)) != null) {
                for (int i = 0; i < configs.size(); ++i) {
                    PdfDictionary config = configs.getAsDict(i);
                    if (config == null) continue;
                    configsList.add(config);
                }
            }
            HashSet<PdfObject> ocgs = new HashSet<PdfObject>();
            PdfArray ocgsArray = properties.getAsArray(PdfName.OCGS);
            if (ocgsArray != null) {
                for (int i = 0; i < ocgsArray.size(); ++i) {
                    ocgs.add(ocgsArray.getPdfObject(i));
                }
            }
            HashSet<String> names = new HashSet<String>();
            HashSet<PdfObject> order = new HashSet<PdfObject>();
            for (PdfDictionary config : configsList) {
                PdfString name = config.getAsString(PdfName.NAME);
                if (name == null) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"optional.content.configuration.dictionary.shall.contain.name.entry", (Object[])new Object[0]));
                }
                String name1 = name.toUnicodeString();
                if (names.contains(name1)) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"value.of.name.entry.shall.be.unique.amongst.all.optional.content.configuration.dictionaries", (Object[])new Object[0]));
                }
                names.add(name1);
                if (config.contains(PdfName.AS)) {
                    throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"the.as.key.shall.not.appear.in.any.optional.content.configuration.dictionary", (Object[])new Object[0]));
                }
                PdfArray orderArray = config.getAsArray(PdfName.ORDER);
                if (orderArray == null) continue;
                this.fillOrderRecursively(orderArray, order);
            }
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"order.array.shall.contain.references.to.all.ocgs", (Object[])new Object[0]));
            }
            ocgs.retainAll(order);
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"order.array.shall.contain.references.to.all.ocgs", (Object[])new Object[0]));
            }
        }
    }

    private void fillOrderRecursively(PdfArray orderArray, HashSet<PdfObject> order) {
        for (int i = 0; i < orderArray.size(); ++i) {
            PdfArray orderChild = orderArray.getAsArray(i);
            if (orderChild == null) {
                order.add(orderArray.getPdfObject(i));
                continue;
            }
            this.fillOrderRecursively(orderChild, order);
        }
    }
}

