/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.resolver.resource;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.exceptions.ReadingByteLimitException;
import com.itextpdf.io.resolver.resource.IResourceRetriever;
import com.itextpdf.io.resolver.resource.LimitedInputStream;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceRetriever
implements IResourceRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceRetriever.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 300000;
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private long resourceSizeByteLimit = Long.MAX_VALUE;
    private int connectTimeout = 300000;
    private int readTimeout = 300000;

    public long getResourceSizeByteLimit() {
        return this.resourceSizeByteLimit;
    }

    public IResourceRetriever setResourceSizeByteLimit(long resourceSizeByteLimit) {
        this.resourceSizeByteLimit = resourceSizeByteLimit;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public IResourceRetriever setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public IResourceRetriever setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public InputStream getInputStreamByUrl(URL url) throws IOException {
        if (this.urlFilter(url)) {
            return new LimitedInputStream(UrlUtil.getInputStreamOfFinalConnection(url, this.connectTimeout, this.readTimeout), this.resourceSizeByteLimit);
        }
        LOGGER.warn(MessageFormatUtil.format((String)"Resource with given URL ({0}) was filtered out.", (Object[])new Object[]{url}));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getByteArrayByUrl(URL url) throws IOException {
        try (InputStream stream = this.getInputStreamByUrl(url);){
            if (stream != null) {
                byte[] byArray2 = StreamUtil.inputStreamToArray(stream);
                return byArray2;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (ReadingByteLimitException ex) {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to retrieve resource with given URL ({0}) and resource size byte limit ({1}).", (Object[])new Object[]{url, this.resourceSizeByteLimit}));
            return null;
        }
    }

    protected boolean urlFilter(URL url) {
        return true;
    }
}

