/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.ProcessInfo;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.io.util.CliCommandUtil;
import com.itextpdf.io.util.ImageMagickCompareResult;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageMagickHelper {
    public static final String MAGICK_COMPARE_ENVIRONMENT_VARIABLE = "ITEXT_MAGICK_COMPARE_EXEC";
    static final String MAGICK_COMPARE_KEYWORD = "ImageMagick Studio LLC";
    private static final String TEMP_FILE_PREFIX = "itext_im_io_temp";
    private static final String DIFF_PIXELS_OUTPUT_REGEXP = "^\\d+\\.*\\d*(e\\+\\d+)?";
    private static final Pattern pattern = Pattern.compile("^\\d+\\.*\\d*(e\\+\\d+)?");
    private String compareExec;

    public ImageMagickHelper() {
        this(null);
    }

    public ImageMagickHelper(String newCompareExec) {
        this.compareExec = newCompareExec;
        if (this.compareExec == null) {
            this.compareExec = SystemUtil.getPropertyOrEnvironmentVariable((String)MAGICK_COMPARE_ENVIRONMENT_VARIABLE);
        }
        if (!CliCommandUtil.isVersionCommandExecutable(this.compareExec, MAGICK_COMPARE_KEYWORD)) {
            throw new IllegalArgumentException("ImageMagick comparison command specified incorrectly. Set the ITEXT_MAGICK_COMPARE_EXEC environment variable with the CLI command which can run the ImageMagic comparison. See BUILDING.MD in the root of the repository for more details.");
        }
    }

    public String getCliExecutionCommand() {
        return this.compareExec;
    }

    public boolean runImageMagickImageCompare(String outImageFilePath, String cmpImageFilePath, String diffImageName) throws IOException, InterruptedException {
        return this.runImageMagickImageCompare(outImageFilePath, cmpImageFilePath, diffImageName, null);
    }

    public boolean runImageMagickImageCompare(String outImageFilePath, String cmpImageFilePath, String diffImageName, String fuzzValue) throws IOException, InterruptedException {
        ImageMagickCompareResult compareResult = this.runImageMagickImageCompareAndGetResult(outImageFilePath, cmpImageFilePath, diffImageName, fuzzValue);
        return compareResult.isComparingResultSuccessful();
    }

    public boolean runImageMagickImageCompareWithThreshold(String outImageFilePath, String cmpImageFilePath, String diffImageName, String fuzzValue, long threshold) throws IOException, InterruptedException {
        ImageMagickCompareResult compareResult = this.runImageMagickImageCompareAndGetResult(outImageFilePath, cmpImageFilePath, diffImageName, fuzzValue);
        if (compareResult.isComparingResultSuccessful()) {
            return true;
        }
        return compareResult.getDiffPixels() <= threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageMagickCompareResult runImageMagickImageCompareAndGetResult(String outImageFilePath, String cmpImageFilePath, String diffImageName, String fuzzValue) throws IOException, InterruptedException {
        ImageMagickCompareResult imageMagickCompareResult;
        if (!ImageMagickHelper.validateFuzziness(fuzzValue)) {
            throw new IllegalArgumentException("Invalid fuzziness value: " + fuzzValue);
        }
        fuzzValue = fuzzValue == null ? "" : " -metric AE -fuzz <fuzzValue>%".replace("<fuzzValue>", fuzzValue);
        String replacementOutFile = null;
        String replacementCmpFile = null;
        String replacementDiff = null;
        try {
            replacementOutFile = FileUtil.createTempCopy((String)outImageFilePath, (String)TEMP_FILE_PREFIX, null);
            replacementCmpFile = FileUtil.createTempCopy((String)cmpImageFilePath, (String)TEMP_FILE_PREFIX, null);
            replacementDiff = FileUtil.createTempFile((String)TEMP_FILE_PREFIX, (String)".png").getAbsolutePath();
            String currCompareParams = fuzzValue + " '" + replacementOutFile + "' '" + replacementCmpFile + "' '" + replacementDiff + "'";
            ProcessInfo processInfo = SystemUtil.runProcessAndGetProcessInfo((String)this.compareExec, (String)currCompareParams);
            boolean comparingResult = processInfo.getExitCode() == 0;
            long diffPixels = ImageMagickHelper.parseImageMagickProcessOutput(processInfo.getProcessErrOutput());
            ImageMagickCompareResult resultInfo = new ImageMagickCompareResult(comparingResult, diffPixels);
            if (FileUtil.fileExists((String)replacementDiff)) {
                FileUtil.copy((String)replacementDiff, (String)diffImageName);
            }
            imageMagickCompareResult = resultInfo;
        }
        catch (Throwable throwable) {
            FileUtil.removeFiles((String[])new String[]{replacementOutFile, replacementCmpFile, replacementDiff});
            throw throwable;
        }
        FileUtil.removeFiles((String[])new String[]{replacementOutFile, replacementCmpFile, replacementDiff});
        return imageMagickCompareResult;
    }

    static boolean validateFuzziness(String fuzziness) {
        if (null == fuzziness) {
            return true;
        }
        try {
            return Double.parseDouble(fuzziness) >= 0.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static long parseImageMagickProcessOutput(String processOutput) throws IOException {
        String[] processOutputLines;
        if (null == processOutput) {
            throw new IllegalArgumentException("ImageMagick process output is null.");
        }
        if (processOutput.isEmpty()) {
            return 0L;
        }
        for (String line : processOutputLines = processOutput.split("\n")) {
            try {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                return Double.valueOf(matcher.group()).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("ImageMagick process execution finished with errors: " + processOutput);
    }
}

