/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.LabelUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INameContainer;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupElementNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupTextNode;
import com.itextpdf.svg.element.SvgImage;
import java.util.Arrays;
import java.util.List;

public class AlternateDescriptionResolver {
    private static final List<String> ALTERNATIVE_DESCRIPTION_RESOLUTION_ORDER = Arrays.asList("alt", "title", "aria-label", "aria-description");

    public void resolve(IAccessibleElement accessibleElement, IElementNode element) {
        boolean hasManagedToResolveSpecificImplementation = false;
        if ("svg".equalsIgnoreCase(element.name())) {
            hasManagedToResolveSpecificImplementation = this.resolveSvg((SvgImage)accessibleElement, element);
        } else if ("a".equalsIgnoreCase(element.name())) {
            hasManagedToResolveSpecificImplementation = this.resolveLink(accessibleElement, element);
        }
        if (hasManagedToResolveSpecificImplementation) {
            return;
        }
        this.resolveFallback(accessibleElement, element);
    }

    public void resolveLabelableElement(IAccessibleElement accessibleElement, IElementNode element, ProcessorContext context) {
        if (LabelUtil.isLabelable((INameContainer)element)) {
            AlternateDescriptionResolver.setAltDescForActivelyLabeledElements(accessibleElement, element, context);
            AlternateDescriptionResolver.setAltDescForPassivelyLabelledElements(accessibleElement, element, context, "aria-labelledby");
            AlternateDescriptionResolver.setAltDescForPassivelyLabelledElements(accessibleElement, element, context, "aria-describedby");
        }
    }

    protected boolean resolveLink(IAccessibleElement accessibleElement, IElementNode element) {
        List children = element.childNodes();
        if (children.size() == 1 && ((INode)children.get(0)).childNodes().isEmpty() && children.get(0) instanceof JsoupElementNode && ((JsoupElementNode)children.get(0)).getAttribute("alt") != null) {
            String result = ((JsoupElementNode)children.get(0)).getAttribute("alt");
            accessibleElement.getAccessibilityProperties().setAlternateDescription(result);
            return true;
        }
        return false;
    }

    protected void resolveFallback(IAccessibleElement accessibleElement, IElementNode element) {
        for (String s : ALTERNATIVE_DESCRIPTION_RESOLUTION_ORDER) {
            String alt = element.getAttribute(s);
            if (alt == null || alt.isEmpty()) continue;
            accessibleElement.getAccessibilityProperties().setAlternateDescription(alt);
            break;
        }
    }

    protected boolean resolveSvg(SvgImage accessibleElement, IElementNode element) {
        for (INode childNode : element.childNodes()) {
            IElementNode childElement;
            if (!(childNode instanceof IElementNode) || !"desc".equalsIgnoreCase((childElement = (IElementNode)childNode).name())) continue;
            if (childElement.childNodes().isEmpty()) break;
            INode firstChild = (INode)childElement.childNodes().get(0);
            if (firstChild instanceof JsoupTextNode) {
                JsoupTextNode textNode = (JsoupTextNode)firstChild;
                accessibleElement.getAccessibilityProperties().setAlternateDescription(textNode.wholeText());
            }
            return true;
        }
        return false;
    }

    private static void setAltDescForPassivelyLabelledElements(IAccessibleElement accessibleElement, IElementNode element, ProcessorContext context, String property) {
        if (element.getAttribute(property) != null) {
            String[] ids = element.getAttribute(property).split(" ");
            StringBuilder alt = new StringBuilder();
            for (String id : ids) {
                String description = context.getLabelContext().getAltDescription(id);
                if (description == null) continue;
                alt.append(description);
            }
            ((IPropertyContainer)accessibleElement).setProperty(0x20000F, (Object)context.getConformance());
            accessibleElement.getAccessibilityProperties().setAlternateDescription(alt.toString());
        }
    }

    private static void setAltDescForActivelyLabeledElements(IAccessibleElement accessibleElement, IElementNode element, ProcessorContext context) {
        String id = element.getAttribute("id");
        if (id == null) {
            return;
        }
        ((IPropertyContainer)accessibleElement).setProperty(0x20000F, (Object)context.getConformance());
        String text = context.getLabelContext().getAltDescription(id);
        accessibleElement.getAccessibilityProperties().setAlternateDescription(text);
    }
}

