/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.html2pdf.attach.DocumentTreeUtil;
import com.itextpdf.html2pdf.attach.IDocumentTreeJob;
import com.itextpdf.html2pdf.attach.impl.LabelUtil;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INameContainer;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.ITextNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LabelContext
implements IDocumentTreeJob {
    private final Map<String, String> idToDesc = new HashMap<String, String>();
    private final Map<String, IElementNode> idToElement = new HashMap<String, IElementNode>();
    private final LabelIdGenerator idGenerator = new LabelIdGenerator();

    public String getAltDescription(String id) {
        String desc = this.idToDesc.get(id);
        return desc == null ? LabelContext.getTextRepresentation(this.idToElement.get(id)) : desc;
    }

    @Override
    public void process(INode node, int level) {
        if (node instanceof IElementNode) {
            IElementNode elem = (IElementNode)node;
            if (elem.getAttribute("id") != null) {
                this.idToElement.put(((IElementNode)node).getAttribute("id"), (IElementNode)node);
            }
            if ("label".equals(elem.name())) {
                this.parseLabelDesc(elem);
            }
        }
    }

    private void parseLabelDesc(IElementNode elem) {
        if (elem.getAttribute("for") != null) {
            this.idToDesc.put(elem.getAttribute("for"), LabelContext.getTextRepresentation(elem));
        } else {
            ImplicitLabelTextNodeCollector collector = new ImplicitLabelTextNodeCollector();
            DocumentTreeUtil.traverse((INode)elem, Collections.singletonList(collector));
            if (collector.getLabeledElement() != null) {
                String id = this.generateIdIfNotExists(collector.getLabeledElement());
                this.idToDesc.put(id, collector.getText());
            }
        }
    }

    private String generateIdIfNotExists(IElementNode labeledElement) {
        String id = labeledElement.getAttribute("id");
        if (id == null) {
            String generatedId = this.idGenerator.generateId();
            labeledElement.getAttributes().setAttribute("id", generatedId);
            return generatedId;
        }
        return id;
    }

    private static String getTextRepresentation(IElementNode elem) {
        if (elem == null) {
            return null;
        }
        SimpleTextNodeCollector collector = new SimpleTextNodeCollector();
        DocumentTreeUtil.traverse((INode)elem, Collections.singletonList(collector));
        return collector.getText();
    }

    private static final class LabelIdGenerator {
        private int counter = 0;

        public String generateId() {
            return "idForLabel" + Integer.toString(this.counter++);
        }
    }

    private static final class ImplicitLabelTextNodeCollector
    implements IDocumentTreeJob {
        private IElementNode labeledElement = null;
        private int stackSize = -1;
        private final SimpleTextNodeCollector collector = new SimpleTextNodeCollector();

        @Override
        public void process(INode iNode, int level) {
            if (this.stackSize == level) {
                this.stackSize = -1;
            }
            if (this.stackSize == 0) {
                this.stackSize = level - this.labeledElement.childNodes().size();
            }
            if (this.stackSize >= 0) {
                return;
            }
            if (this.labeledElement == null && iNode instanceof IElementNode && LabelUtil.isLabelable((INameContainer)((IElementNode)iNode))) {
                this.labeledElement = (IElementNode)iNode;
                if (this.labeledElement.childNodes().isEmpty()) {
                    return;
                }
                this.stackSize = 0;
                return;
            }
            this.collector.process(iNode, level);
        }

        public String getText() {
            return this.collector.getText();
        }

        public IElementNode getLabeledElement() {
            return this.labeledElement;
        }
    }

    private static final class SimpleTextNodeCollector
    implements IDocumentTreeJob {
        private final StringBuilder textBuilder = new StringBuilder();

        @Override
        public void process(INode node, int level) {
            if (node instanceof ITextNode) {
                String text = ((ITextNode)node).wholeText();
                if (SimpleTextNodeCollector.onlySpacesOrNewlines(text)) {
                    return;
                }
                this.textBuilder.append(text).append(' ');
            }
        }

        public String getText() {
            return this.textBuilder.toString();
        }

        private static boolean onlySpacesOrNewlines(String s) {
            if (s == null) {
                return true;
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\n' || c == '\r') continue;
                return false;
            }
            return true;
        }
    }
}

