/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupElementNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkHelper.class);

    private LinkHelper() {
    }

    public static void applyLinkAnnotation(IPropertyContainer container, String url, ProcessorContext context, IElementNode element) {
        if (container != null) {
            PdfLinkAnnotation linkAnnotation;
            if (url.startsWith("#")) {
                String id = url.substring(1);
                linkAnnotation = context.getLinkContext().getLinkAnnotation(id);
                if (linkAnnotation == null) {
                    linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createGoTo((String)id)).setFlags(4);
                    context.getLinkContext().addLinkAnnotation(id, linkAnnotation);
                }
            } else {
                linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createURI((String)url)).setFlags(4);
            }
            String alternateDescription = LinkHelper.retrieveAlternativeDescription(element);
            if (alternateDescription != null) {
                linkAnnotation.setContents(alternateDescription);
                if (container instanceof IAccessibleElement) {
                    ((IAccessibleElement)container).getAccessibilityProperties().setAlternateDescription(alternateDescription);
                }
            }
            linkAnnotation.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
            container.setProperty(88, (Object)linkAnnotation);
            if (container instanceof ILeafElement && container instanceof IAccessibleElement) {
                ((IAccessibleElement)container).getAccessibilityProperties().setRole("Link");
            }
        }
    }

    public static void createDestination(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        String id = element.getAttribute("id");
        if (id == null) {
            return;
        }
        IPropertyContainer propertyContainer = LinkHelper.getPropertyContainer(tagWorker);
        if (context.getLinkContext().isUsedLinkDestination(id)) {
            if (propertyContainer == null) {
                String tagWorkerClassName = tagWorker != null ? tagWorker.getClass().getName() : "null";
                LOGGER.warn(MessageFormatUtil.format((String)"The anchor link was not handled. Could not create a destination for element \"{0}\" with ID \"{1}\", which is processed by \"{2}\" tag worker class.", (Object[])new Object[]{element.name(), id, tagWorkerClassName}));
                return;
            }
            PdfLinkAnnotation linkAnnotation = context.getLinkContext().getLinkAnnotation(id);
            if (linkAnnotation == null) {
                linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createGoTo((String)id)).setFlags(4);
                context.getLinkContext().addLinkAnnotation(id, linkAnnotation);
            }
            propertyContainer.setProperty(17, (Object)new Tuple2((Object)id, (Object)linkAnnotation.getAction()));
        }
        if (propertyContainer != null) {
            propertyContainer.setProperty(126, (Object)id);
        }
    }

    private static String retrieveAlternativeDescription(IElementNode element) {
        List children = element.childNodes();
        if (children.size() == 1 && ((INode)children.get(0)).childNodes().isEmpty() && children.get(0) instanceof JsoupElementNode && ((JsoupElementNode)children.get(0)).getAttribute("alt") != null) {
            return ((JsoupElementNode)children.get(0)).getAttribute("alt");
        }
        return element.getAttribute("title");
    }

    private static IPropertyContainer getPropertyContainer(ITagWorker tagWorker) {
        if (tagWorker != null) {
            if (tagWorker instanceof SpanTagWorker) {
                List<IPropertyContainer> spanElements = ((SpanTagWorker)tagWorker).getAllElements();
                if (!spanElements.isEmpty()) {
                    return spanElements.get(0);
                }
            } else {
                return tagWorker.getElementResult();
            }
        }
        return null;
    }
}

