/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.forms.xfdf.ActionObject;
import com.itextpdf.forms.xfdf.AnnotObject;
import com.itextpdf.forms.xfdf.AttributeObject;
import com.itextpdf.forms.xfdf.BorderStyleAltObject;
import com.itextpdf.forms.xfdf.DestObject;
import com.itextpdf.forms.xfdf.FObject;
import com.itextpdf.forms.xfdf.FieldObject;
import com.itextpdf.forms.xfdf.FitObject;
import com.itextpdf.forms.xfdf.IdsObject;
import com.itextpdf.forms.xfdf.XfdfFileUtils;
import com.itextpdf.forms.xfdf.XfdfObject;
import com.itextpdf.forms.xfdf.XfdfObjectUtils;
import com.itextpdf.kernel.pdf.PdfName;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XfdfWriter {
    private OutputStream outputStream;
    private static Logger logger = LoggerFactory.getLogger(XfdfWriter.class);

    XfdfWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    void write(XfdfObject xfdfObject) throws TransformerException, ParserConfigurationException {
        this.writeDom(xfdfObject);
    }

    static void addField(FieldObject fieldObject, Element parentElement, Document document, List<FieldObject> fieldList) {
        List<FieldObject> childrenFields = XfdfWriter.findChildrenFields(fieldObject, fieldList);
        Element field = document.createElement("field");
        field.setAttribute("name", fieldObject.getName());
        if (!childrenFields.isEmpty()) {
            for (FieldObject childField : childrenFields) {
                XfdfWriter.addField(childField, field, document, fieldList);
            }
        } else if (fieldObject.getValue() != null && !fieldObject.getValue().isEmpty()) {
            Element value = document.createElement("value");
            value.setTextContent(fieldObject.getValue());
            field.appendChild(value);
        } else {
            logger.info("Field has no value.");
        }
        parentElement.appendChild(field);
    }

    private void writeDom(XfdfObject xfdfObject) throws ParserConfigurationException, TransformerException {
        Document document = XfdfFileUtils.createNewXfdfDocument();
        Element root = document.createElement("xfdf");
        document.appendChild(root);
        if (xfdfObject.getFields() != null && xfdfObject.getFields().getFieldList() != null && !xfdfObject.getFields().getFieldList().isEmpty()) {
            Element fields = document.createElement("fields");
            root.appendChild(fields);
            List<FieldObject> fieldList = xfdfObject.getFields().getFieldList();
            for (FieldObject fieldObject : fieldList) {
                if (fieldObject.getParent() != null) continue;
                XfdfWriter.addField(fieldObject, fields, document, fieldList);
            }
        }
        if (xfdfObject.getAnnots() != null && xfdfObject.getAnnots().getAnnotsList() != null && !xfdfObject.getAnnots().getAnnotsList().isEmpty()) {
            Element annots = document.createElement("annots");
            root.appendChild(annots);
            for (AnnotObject annotObject : xfdfObject.getAnnots().getAnnotsList()) {
                XfdfWriter.addAnnot(annotObject, annots, document);
            }
        }
        if (xfdfObject.getF() != null) {
            Element f = document.createElement("f");
            XfdfWriter.addFAttributes(xfdfObject.getF(), f);
            root.appendChild(f);
        }
        if (xfdfObject.getIds() != null) {
            Element ids = document.createElement("ids");
            XfdfWriter.addIdsAttributes(xfdfObject.getIds(), ids);
            root.appendChild(ids);
        }
        XfdfFileUtils.saveXfdfDocumentToFile(document, this.outputStream);
    }

    private static void addIdsAttributes(IdsObject idsObject, Element ids) {
        if (idsObject.getOriginal() != null) {
            ids.setAttribute("original", idsObject.getOriginal());
        }
        if (idsObject.getModified() != null) {
            ids.setAttribute("modified", idsObject.getModified());
        }
    }

    private static void addFAttributes(FObject fObject, Element f) {
        if (fObject.getHref() != null) {
            f.setAttribute("href", fObject.getHref());
        }
    }

    private static List<FieldObject> findChildrenFields(FieldObject field, List<FieldObject> fieldList) {
        ArrayList<FieldObject> childrenFields = new ArrayList<FieldObject>();
        for (FieldObject currentField : fieldList) {
            if (currentField.getParent() == null || !currentField.getParent().getName().equalsIgnoreCase(field.getName())) continue;
            childrenFields.add(currentField);
        }
        return childrenFields;
    }

    private static void addAnnot(AnnotObject annotObject, Element annots, Document document) {
        Element contents;
        if (annotObject.getName() == null) {
            return;
        }
        Element annot = document.createElement(annotObject.getName());
        for (AttributeObject attr : annotObject.getAttributes()) {
            annot.setAttribute(attr.getName(), attr.getValue());
        }
        if (annotObject.getPopup() != null) {
            Element popup = document.createElement("popup");
            XfdfWriter.addPopup(annotObject.getPopup(), popup, annot);
        }
        if (annotObject.getContents() != null) {
            contents = document.createElement("contents");
            contents.setTextContent(annotObject.getContents().toString().replace('\r', '\n'));
            annot.appendChild(contents);
        }
        if (annotObject.getVertices() != null) {
            contents = document.createElement("vertices");
            contents.setTextContent(annotObject.getVertices());
            annot.appendChild(contents);
        }
        if (annotObject.getAppearance() != null) {
            Element appearance = document.createElement("appearance");
            appearance.setTextContent(annotObject.getAppearance());
            annot.appendChild(appearance);
        }
        if (annotObject.getContentsRichText() != null) {
            Element contentsRichText = document.createElement("contents-richtext");
            contentsRichText.setTextContent(annotObject.getContentsRichText().getValue());
            annot.appendChild(contentsRichText);
        }
        if ("link".equalsIgnoreCase(annotObject.getName())) {
            if (annotObject.getDestination() != null) {
                XfdfWriter.addDest(annotObject.getDestination(), annot, document);
            } else if (annotObject.getAction() != null) {
                Element onActivation = document.createElement("OnActivation");
                XfdfWriter.addActionObject(annotObject.getAction(), onActivation, document);
                annot.appendChild(onActivation);
            } else {
                logger.error("Dest and OnActivation elements are both missing");
            }
            if (annotObject.getBorderStyleAlt() != null) {
                XfdfWriter.addBorderStyleAlt(annotObject.getBorderStyleAlt(), annot, document);
            }
        }
        if ("freetext".equalsIgnoreCase(annotObject.getName())) {
            String defaultStyleString;
            String defaultAppearanceString = annotObject.getDefaultAppearance();
            if (defaultAppearanceString != null) {
                Element defaultAppearance = document.createElement("defaultappearance");
                defaultAppearance.setTextContent(defaultAppearanceString);
                annot.appendChild(defaultAppearance);
            }
            if ((defaultStyleString = annotObject.getDefaultStyle()) != null) {
                Element defaultStyle = document.createElement("defaultstyle");
                defaultStyle.setTextContent(defaultStyleString);
                annot.appendChild(defaultStyle);
            }
        }
        annots.appendChild(annot);
    }

    private static void addBorderStyleAlt(BorderStyleAltObject borderStyleAltObject, Element annot, Document document) {
        Element borderStyleAlt = document.createElement("BorderStyleAlt");
        borderStyleAlt.setAttribute("HCornerRadius", XfdfObjectUtils.convertFloatToString(borderStyleAltObject.getHCornerRadius()));
        borderStyleAlt.setAttribute("VCornerRadius", XfdfObjectUtils.convertFloatToString(borderStyleAltObject.getVCornerRadius()));
        borderStyleAlt.setAttribute("Width", XfdfObjectUtils.convertFloatToString(borderStyleAltObject.getWidth()));
        if (borderStyleAltObject.getDashPattern() != null) {
            borderStyleAlt.setAttribute("DashPattern", Arrays.toString(borderStyleAltObject.getDashPattern()));
        }
        if (borderStyleAltObject.getContent() != null) {
            borderStyleAlt.setTextContent(borderStyleAltObject.getContent());
        }
        annot.appendChild(borderStyleAlt);
    }

    private static void addXYZ(FitObject xyzObject, Element dest, Document document) {
        Element xyz = document.createElement("XYZ");
        xyz.setAttribute("Page", String.valueOf(xyzObject.getPage()));
        xyz.setAttribute("Left", XfdfObjectUtils.convertFloatToString(xyzObject.getLeft()));
        xyz.setAttribute("Bottom", XfdfObjectUtils.convertFloatToString(xyzObject.getBottom()));
        xyz.setAttribute("Right", XfdfObjectUtils.convertFloatToString(xyzObject.getRight()));
        xyz.setAttribute("Top", XfdfObjectUtils.convertFloatToString(xyzObject.getTop()));
        dest.appendChild(xyz);
    }

    private static void addFit(FitObject fitObject, Element dest, Document document) {
        Element fit = document.createElement("Fit");
        fit.setAttribute("Page", String.valueOf(fitObject.getPage()));
        dest.appendChild(fit);
    }

    private static void addFitB(FitObject fitBObject, Element dest, Document document) {
        Element fitB = document.createElement("FitB");
        fitB.setAttribute("Page", String.valueOf(fitBObject.getPage()));
        dest.appendChild(fitB);
    }

    private static void addFitBH(FitObject fitBHObject, Element dest, Document document) {
        Element fitBH = document.createElement("FitBH");
        fitBH.setAttribute("Page", String.valueOf(fitBHObject.getPage()));
        fitBH.setAttribute("Top", XfdfObjectUtils.convertFloatToString(fitBHObject.getTop()));
        dest.appendChild(fitBH);
    }

    private static void addFitBV(FitObject fitBVObject, Element dest, Document document) {
        Element fitBV = document.createElement("FitBV");
        fitBV.setAttribute("Page", String.valueOf(fitBVObject.getPage()));
        fitBV.setAttribute("Left", XfdfObjectUtils.convertFloatToString(fitBVObject.getLeft()));
        dest.appendChild(fitBV);
    }

    private static void addFitH(FitObject fitHObject, Element dest, Document document) {
        Element fitH = document.createElement("FitH");
        fitH.setAttribute("Page", String.valueOf(fitHObject.getPage()));
        fitH.setAttribute("Top", XfdfObjectUtils.convertFloatToString(fitHObject.getTop()));
        dest.appendChild(fitH);
    }

    private static void addFitR(FitObject fitRObject, Element dest, Document document) {
        Element fitR = document.createElement("FitR");
        fitR.setAttribute("Page", String.valueOf(fitRObject.getPage()));
        fitR.setAttribute("Left", XfdfObjectUtils.convertFloatToString(fitRObject.getLeft()));
        fitR.setAttribute("Bottom", XfdfObjectUtils.convertFloatToString(fitRObject.getBottom()));
        fitR.setAttribute("Right", XfdfObjectUtils.convertFloatToString(fitRObject.getRight()));
        fitR.setAttribute("Top", XfdfObjectUtils.convertFloatToString(fitRObject.getTop()));
        dest.appendChild(fitR);
    }

    private static void addFitV(FitObject fitVObject, Element dest, Document document) {
        Element fitV = document.createElement("FitV");
        fitV.setAttribute("Page", String.valueOf(fitVObject.getPage()));
        fitV.setAttribute("Left", XfdfObjectUtils.convertFloatToString(fitVObject.getLeft()));
        dest.appendChild(fitV);
    }

    private static void addDest(DestObject destObject, Element annot, Document document) {
        Element dest = document.createElement("Dest");
        if (destObject.getName() != null) {
            Element named = document.createElement("Named");
            named.setAttribute("name", destObject.getName());
            dest.appendChild(named);
        } else if (destObject.getXyz() != null) {
            XfdfWriter.addXYZ(destObject.getXyz(), dest, document);
        } else if (destObject.getFit() != null) {
            XfdfWriter.addFit(destObject.getFit(), dest, document);
        } else if (destObject.getFitB() != null) {
            XfdfWriter.addFitB(destObject.getFitB(), dest, document);
        } else if (destObject.getFitBH() != null) {
            XfdfWriter.addFitBH(destObject.getFitBH(), dest, document);
        } else if (destObject.getFitBV() != null) {
            XfdfWriter.addFitBV(destObject.getFitBV(), dest, document);
        } else if (destObject.getFitH() != null) {
            XfdfWriter.addFitH(destObject.getFitH(), dest, document);
        } else if (destObject.getFitR() != null) {
            XfdfWriter.addFitR(destObject.getFitR(), dest, document);
        } else if (destObject.getFitV() != null) {
            XfdfWriter.addFitV(destObject.getFitV(), dest, document);
        }
        annot.appendChild(dest);
    }

    private static void addActionObject(ActionObject actionObject, Element onActivation, Document document) {
        Element action = document.createElement("Action");
        if (actionObject.getUri() != null) {
            Element uri = document.createElement("URI");
            uri.setAttribute("Name", actionObject.getUri().getValue());
            if (actionObject.isMap()) {
                uri.setAttribute("IsMap", "true");
            } else {
                uri.setAttribute("IsMap", "false");
            }
            action.appendChild(uri);
        } else if (PdfName.GoTo.equals((Object)actionObject.getType())) {
            Element goTo = document.createElement("GoTo");
            XfdfWriter.addDest(actionObject.getDestination(), goTo, document);
            action.appendChild(goTo);
        } else if (PdfName.GoToR.equals((Object)actionObject.getType())) {
            Element goToR = document.createElement("GoToR");
            if (actionObject.getDestination() != null) {
                XfdfWriter.addDest(actionObject.getDestination(), goToR, document);
            } else if (actionObject.getFileOriginalName() != null) {
                Element file = document.createElement("File");
                file.setAttribute("OriginalName", actionObject.getFileOriginalName());
                goToR.appendChild(file);
            } else {
                logger.error("Dest or File elements are missing.");
            }
            action.appendChild(goToR);
        } else if (PdfName.Named.equals((Object)actionObject.getType())) {
            Element named = document.createElement("Named");
            named.setAttribute("Name", actionObject.getNameAction().getValue());
            action.appendChild(named);
        } else if (PdfName.Launch.equals((Object)actionObject.getType())) {
            Element launch = document.createElement("Launch");
            if (actionObject.getFileOriginalName() != null) {
                Element file = document.createElement("File");
                file.setAttribute("OriginalName", actionObject.getFileOriginalName());
                launch.appendChild(file);
            } else {
                logger.error("File element is missing");
            }
            if (actionObject.isNewWindow()) {
                launch.setAttribute("NewWindow", "true");
            }
            action.appendChild(launch);
        }
        onActivation.appendChild(action);
    }

    private static void addPopup(AnnotObject popupAnnotObject, Element popup, Element annot) {
        for (AttributeObject attr : popupAnnotObject.getAttributes()) {
            popup.setAttribute(attr.getName(), attr.getValue());
        }
        annot.appendChild(popup);
    }
}

