/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.element;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.form.element.AbstractSelectField;
import com.itextpdf.forms.form.element.SelectFieldItem;
import com.itextpdf.forms.form.renderer.SelectFieldComboBoxRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComboBoxField
extends AbstractSelectField {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComboBoxField.class);
    private String selectedExportValue;

    public ComboBoxField(String id) {
        super(id);
    }

    public String getSelectedExportValue() {
        return this.selectedExportValue;
    }

    public ComboBoxField setSelected(int index) {
        if (index < 0 || index >= this.getItems().size()) {
            String message = MessageFormatUtil.format((String)"Index: {0}, Size: {1}", (Object[])new Object[]{index, this.getItems().size()});
            throw new IndexOutOfBoundsException(message);
        }
        this.setSelected(this.getItems().get(index));
        return this;
    }

    public ComboBoxField setSelected(String value) {
        this.clearSelected();
        this.selectedExportValue = value;
        boolean found = false;
        for (SelectFieldItem option : this.getItems()) {
            if (!option.getExportValue().equals(value)) continue;
            if (!found) {
                option.getElement().setProperty(0x200009, (Object)true);
                found = true;
                continue;
            }
            LOGGER.warn("More than one option with the same value. This is an invalid state.");
        }
        return this;
    }

    public ComboBoxField setSelected(SelectFieldItem item) {
        if (item == null) {
            return this;
        }
        this.setSelected(item.getExportValue());
        return this;
    }

    @Override
    public void addOption(SelectFieldItem option) {
        boolean found = false;
        for (SelectFieldItem item : this.getItems()) {
            if (!item.getExportValue().equals(option.getExportValue())) continue;
            found = true;
            break;
        }
        if (found) {
            LOGGER.warn("More than one option with the same value. This is an invalid state.");
        }
        super.addOption(option);
    }

    public SelectFieldItem getSelectedOption() {
        if (this.selectedExportValue == null) {
            return null;
        }
        for (SelectFieldItem option : this.getItems()) {
            if (!option.getExportValue().equals(this.selectedExportValue)) continue;
            return option;
        }
        return null;
    }

    protected IRenderer makeNewRenderer() {
        return new SelectFieldComboBoxRenderer(this);
    }

    private void clearSelected() {
        this.selectedExportValue = null;
        for (SelectFieldItem option : this.getItems()) {
            option.getElement().deleteOwnProperty(0x200009);
        }
    }
}

