/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormAnnotationUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PdfFormFieldMergeUtil {
    private PdfFormFieldMergeUtil() {
    }

    public static void mergeKidsWithSameNames(PdfFormField parentField, boolean throwExceptionOnError) {
        PdfDictionary parent = parentField.getPdfObject();
        if (parentField.isInReadingMode()) {
            return;
        }
        PdfArray kids = parent.getAsArray(PdfName.Kids);
        if (kids == null || kids.size() == 0) {
            return;
        }
        LinkedHashMap<String, AbstractPdfFormField> addedKids = new LinkedHashMap<String, AbstractPdfFormField>();
        ArrayList<AbstractPdfFormField> newKids = new ArrayList<AbstractPdfFormField>();
        for (AbstractPdfFormField kid : parentField.getChildFields()) {
            if (kid instanceof PdfFormField) {
                PdfFormFieldMergeUtil.mergeKidsWithSameNames((PdfFormField)kid, throwExceptionOnError);
                String kidName = PdfFormFieldMergeUtil.getPartialName(kid);
                if (addedKids.containsKey(kidName) && PdfFormFieldMergeUtil.mergeTwoFieldsWithTheSameNames((PdfFormField)((Object)addedKids.get(kidName)), (PdfFormField)kid, throwExceptionOnError)) continue;
                addedKids.put(kidName, kid);
                newKids.add(kid);
                continue;
            }
            newKids.add(kid);
        }
        parentField.replaceKids(newKids);
        PdfFormFieldMergeUtil.processDirtyAnnotations(parentField, throwExceptionOnError);
    }

    public static boolean mergeTwoFieldsWithTheSameNames(PdfFormField firstField, PdfFormField secondField, boolean throwExceptionOnError) {
        PdfName firstFieldFormType = firstField.getFormType();
        PdfObject firstFieldValue = firstField.getValue();
        PdfObject secondFieldValue = secondField.getValue();
        PdfObject firstFieldDefaultValue = firstField.getDefaultValue();
        PdfObject secondFieldDefaultValue = secondField.getDefaultValue();
        if (firstFieldFormType != null && !firstFieldFormType.equals((Object)secondField.getFormType()) || firstFieldValue != null && secondFieldValue != null && !firstFieldValue.equals(secondFieldValue) || firstFieldDefaultValue != null && secondFieldDefaultValue != null && !firstFieldDefaultValue.equals(secondFieldDefaultValue)) {
            if (throwExceptionOnError) {
                throw new PdfException(MessageFormatUtil.format((String)"Cannot merge form fields with the same names. Partial name is {0}. Field dictionaries with the same fully qualified field name shall have the same field type (FT), value (V), and default value (DV).", (Object[])new Object[]{firstField.getPartialFieldName()}));
            }
            Logger logger = LoggerFactory.getLogger(PdfFormFieldMergeUtil.class);
            logger.warn(MessageFormatUtil.format((String)"Cannot merge form fields with the same fully qualified names. Partial name is {0}. Field type (FT), value (V), and default value (DV) should be the same", (Object[])new Object[]{firstField.getPartialFieldName()}));
            return false;
        }
        PdfFormFieldMergeUtil.mergeFormFields(firstField, secondField, throwExceptionOnError);
        return true;
    }

    public static String getPartialName(AbstractPdfFormField field) {
        if (PdfFormAnnotationUtil.isPureWidget(field.getPdfObject())) {
            return null;
        }
        if (field instanceof PdfFormField) {
            return ((PdfFormField)field).getPartialFieldName().toUnicodeString();
        }
        return "";
    }

    public static void processDirtyAnnotations(PdfFormField parentField, boolean throwExceptionOnError) {
        for (PdfFormField field : parentField.getChildFormFields()) {
            PdfDictionary formDict = field.getPdfObject();
            if (field.getChildFields().size() <= 0 || field.getChildFormFields().size() != 0) continue;
            boolean shouldBeMerged = true;
            if (!PdfName.Btn.equals((Object)parentField.getFormType()) || !parentField.getFieldFlag(PdfButtonFormField.FF_RADIO)) {
                if (formDict.containsKey(PdfName.T)) continue;
                for (PdfName key : formDict.keySet()) {
                    if (PdfName.Parent.equals((Object)key) || PdfName.Kids.equals((Object)key) || formDict.get(key).equals(parentField.getPdfObject().get(key))) continue;
                    shouldBeMerged = false;
                    break;
                }
            }
            if (!shouldBeMerged) continue;
            parentField.removeChild(field);
            formDict.remove(PdfName.Parent);
            PdfFormFieldMergeUtil.mergeFormFields(parentField, field, throwExceptionOnError);
        }
    }

    private static void mergeFormFields(PdfFormField firstField, PdfFormField secondField, boolean throwExceptionOnError) {
        PdfFormAnnotationUtil.separateWidgetAndField(firstField);
        PdfFormAnnotationUtil.separateWidgetAndField(secondField);
        PdfDictionary firstFieldDict = firstField.getPdfObject();
        PdfDictionary secondFieldDict = secondField.getPdfObject();
        for (PdfName key : new ArrayList(secondFieldDict.keySet())) {
            if (PdfName.Kids.equals((Object)key)) {
                for (AbstractPdfFormField kid : new ArrayList<AbstractPdfFormField>(secondField.getChildFields())) {
                    firstField.addKid(kid, throwExceptionOnError);
                }
                continue;
            }
            if (PdfName.Parent.equals((Object)key) || firstFieldDict.containsKey(key)) continue;
            firstField.put(key, secondFieldDict.get(key));
        }
    }
}

