/*
 * Decompiled with CFR 0.152.
 */
package api;

import core.TestNGMethods;
import core.reports.TestReporter;
import io.restassured.response.Response;
import java.util.HashMap;

public class ApiResponseHandler {
    private static HashMap<String, Response> response = new HashMap();
    private static HashMap<String, Object> responseBody = new HashMap();
    private static HashMap<String, Object> responseHeaders = new HashMap();

    public static HashMap<String, Response> getResponse() {
        return response;
    }

    public static void setResponse(Response currentResponse) {
        response.put(TestNGMethods.getRunningTestMethod().getName(), currentResponse);
        ApiResponseHandler.setResponseBody(currentResponse);
        ApiResponseHandler.setResponseHeaders(currentResponse);
    }

    public static HashMap getResponseBody() {
        return responseBody;
    }

    public static void setResponseBody(Response lastResponse) {
        HashMap responseHashMap = (HashMap)lastResponse.jsonPath().get();
        responseHashMap.forEach((K, V) -> responseBody.put((String)K, V));
    }

    public static HashMap<String, Object> getResponseHeaders() {
        return responseHeaders;
    }

    public static void setResponseHeaders(Response lastResponse) {
        lastResponse.headers().iterator().forEachRemaining(x -> responseHeaders.put(x.getName(), x.getValue()));
    }

    public static String getResponseValueAsString(String key) {
        String value = ApiResponseHandler.getResponseValue("header", key).toString();
        if (value.isEmpty()) {
            value = ApiResponseHandler.getResponseValue("body", key).toString();
        }
        return value;
    }

    public static int getResponseValueAsInteger(String key) {
        String valueString = ApiResponseHandler.getResponseValueAsString(key);
        int value = 0;
        try {
            value = valueString.isEmpty() ? 0 : Integer.parseInt(valueString);
            return value;
        }
        catch (Throwable throwable) {
            TestReporter.error((String)("Error while extracting number from API response, key=" + key + "\n" + throwable.getMessage()), (Boolean)false);
            return value;
        }
    }

    public static Object getResponseValue(String from, String key) {
        switch (from.toLowerCase()) {
            case "header": {
                return ApiResponseHandler.getResponseHeaderValue(key);
            }
            case "body": {
                return ApiResponseHandler.getResponseBodyValue(key);
            }
        }
        return "";
    }

    private static Object getResponseBodyValue(String key) {
        if (ApiResponseHandler.getResponseBody().containsKey(key)) {
            return ApiResponseHandler.getResponseBody().get(key);
        }
        return "";
    }

    private static Object getResponseHeaderValue(String key) {
        if (ApiResponseHandler.getResponseHeaders().containsKey(key)) {
            return ApiResponseHandler.getResponseHeaders().get(key);
        }
        return "";
    }
}

