/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.stamp;

import com.ironsoftware.ironpdf.stamp.Stamper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;

public class ImageStamper
extends Stamper {
    private byte[] imageData;

    public ImageStamper(String imagePath) throws IOException {
        this.imageData = Files.readAllBytes(Paths.get(imagePath, new String[0]));
    }

    public ImageStamper(Path imagePath) throws IOException {
        this.imageData = Files.readAllBytes(imagePath);
    }

    public ImageStamper(byte[] imageBytes) {
        this.imageData = imageBytes;
    }

    public ImageStamper(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        this.imageData = byteArrayOutputStream.toByteArray();
    }

    public final byte[] getImageData() {
        return this.imageData;
    }
}

