/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.PdfDocument;
import com.ironsoftware.ironpdf.internal.proto.BytesResultStream;
import com.ironsoftware.ironpdf.internal.proto.GetBinaryDataRequest;
import com.ironsoftware.ironpdf.internal.proto.GetRevisionRequest;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentConstructorStream;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResult;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PdfDocument_Api {
    static final Logger logger = LoggerFactory.getLogger(PdfDocument.class);

    public static InternalPdfDocument fromFile(String pdfFilePath) throws IOException {
        return PdfDocument_Api.fromFile(pdfFilePath, null, null);
    }

    public static InternalPdfDocument fromFile(String pdfFilePath, String password) throws IOException {
        return PdfDocument_Api.fromFile(pdfFilePath, password, null);
    }

    public static InternalPdfDocument fromFile(String pdfFilePath, String password, String ownerPassword) throws IOException {
        if (Utils_StringHelper.isNullOrWhiteSpace(pdfFilePath)) {
            throw new IllegalArgumentException("Value 'pdfFilePath' cannot be null or empty.");
        }
        String absoluteFilePath = new File(pdfFilePath).getAbsolutePath();
        if (!new File(absoluteFilePath).isFile()) {
            throw new IOException(String.format("%1$s is not a valid PDF file path. That file does not exist.", absoluteFilePath));
        }
        byte[] pdfData = Files.readAllBytes(Paths.get(pdfFilePath, new String[0]));
        if (pdfData.length == 0) {
            throw new IOException(String.format("PdfData Stream is null or empty.  Can not create a PDF document from invalid data. %1$s", pdfFilePath));
        }
        return PdfDocument_Api.fromBytes(pdfData, password, ownerPassword);
    }

    public static InternalPdfDocument fromBytes(byte[] pdfFileBytes, String userPassword, String ownerPassword) {
        RpcClient client = Access.ensureConnection();
        logger.info("open PDF");
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResult> resultChunks = new ArrayList<PdfDocumentResult>();
        StreamObserver<PdfDocumentConstructorStream> requestStream = client.stub.pdfDocumentFromBytes(new Utils_ReceivingCustomStreamObserver<PdfDocumentResult>(finishLatch, resultChunks));
        PdfDocumentConstructorStream.Builder pdfDocumentConstructor_info = PdfDocumentConstructorStream.newBuilder();
        PdfDocumentConstructorStream.Info.Builder info = PdfDocumentConstructorStream.Info.newBuilder();
        if (!Utils_StringHelper.isNullOrWhiteSpace(userPassword) || !Utils_StringHelper.isNullOrWhiteSpace(ownerPassword)) {
            info.setUserPassword(!Utils_StringHelper.isNullOrWhiteSpace(userPassword) ? userPassword : "");
            info.setOwnerPassword(!Utils_StringHelper.isNullOrWhiteSpace(ownerPassword) ? ownerPassword : "");
            pdfDocumentConstructor_info.setInfo(info);
            requestStream.onNext((Object)pdfDocumentConstructor_info.build());
        }
        Iterator<byte[]> it = Utils_Util.chunk(pdfFileBytes);
        while (it.hasNext()) {
            byte[] bytes = it.next();
            PdfDocumentConstructorStream.Builder pdfDocumentConstructor_data = PdfDocumentConstructorStream.newBuilder();
            pdfDocumentConstructor_data.setPdfBytesChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)pdfDocumentConstructor_data.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static void saveAs(InternalPdfDocument internalPdfDocument, String filePath) throws IOException {
        byte[] data = PdfDocument_Api.getBytes(internalPdfDocument, false);
        PdfDocument_Api.saveAs(data, filePath);
    }

    public static void saveAsRevision(InternalPdfDocument internalPdfDocument, String filePath) throws IOException {
        byte[] data = PdfDocument_Api.getBytes(internalPdfDocument, true);
        PdfDocument_Api.saveAs(data, filePath);
    }

    public static byte[] getBytes(InternalPdfDocument internalPdfDocument, boolean isIncremental) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList resultChunks = new ArrayList();
        GetBinaryDataRequest.Builder req = GetBinaryDataRequest.newBuilder();
        req.setIsIncremental(isIncremental);
        req.setDocument(internalPdfDocument.remoteDocument);
        client.stub.pdfDocumentGetBinaryData(req.build(), new Utils_ReceivingCustomStreamObserver<BytesResultStream>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        List<byte[]> bytesChunks = resultChunks.stream().map(res -> {
            if (res.getResultOrExceptionCase() == BytesResultStream.ResultOrExceptionCase.EXCEPTION) {
                throw Exception_Converter.fromProto(res.getException());
            }
            return res.getResultChunk().toByteArray();
        }).collect(Collectors.toList());
        return Utils_Util.combineChunk(bytesChunks);
    }

    public static InternalPdfDocument getRevision(InternalPdfDocument internalPdfDocument, int index) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResult> resultChunks = new ArrayList<PdfDocumentResult>();
        GetRevisionRequest.Builder req = GetRevisionRequest.newBuilder();
        req.setIndex(index);
        req.setDocument(internalPdfDocument.remoteDocument);
        client.stub.pdfDocumentGetRevision(req.build(), new Utils_ReceivingCustomStreamObserver<PdfDocumentResult>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static void saveAs(byte[] pdfData, String filePath) throws IOException {
        File parent;
        logger.info("save PDF to file: " + filePath);
        File file = new File(filePath);
        if (!file.exists() && (parent = file.getParentFile()) != null) {
            Files.createDirectories(parent.toPath(), new FileAttribute[0]);
        }
        try (FileOutputStream stream = new FileOutputStream(filePath);){
            stream.write(pdfData);
        }
    }

    public static InternalPdfDocument fromBytes(byte[] pdfFileBytes, String userPassword) {
        return PdfDocument_Api.fromBytes(pdfFileBytes, userPassword, null);
    }

    public static InternalPdfDocument fromBytes(byte[] pdfFileBytes) {
        return PdfDocument_Api.fromBytes(pdfFileBytes, null, null);
    }
}

