/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.image.ImageBehavior;
import com.ironsoftware.ironpdf.internal.proto.DrawBitmapRequestStream;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.ExtractAllRawImagesRequest;
import com.ironsoftware.ironpdf.internal.proto.ImageFilesToPdfRequestStream;
import com.ironsoftware.ironpdf.internal.proto.ImageResultStream;
import com.ironsoftware.ironpdf.internal.proto.ImagesResultStream;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResult;
import com.ironsoftware.ironpdf.internal.proto.PdfToImagesRequest;
import com.ironsoftware.ironpdf.internal.proto.PdfToMultiPageTiffImageRequest;
import com.ironsoftware.ironpdf.internal.proto.RawImageChunkWithIndexAndFileType;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Image_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Render_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.render.ChromePdfRenderOptions;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.IntStream;

public final class Image_Api {
    public static InternalPdfDocument imageToPdf(List<ImageData> imagesData, ImageBehavior imageBehavior, ChromePdfRenderOptions renderOptions) {
        RpcClient client = Access.ensureConnection();
        ImageFilesToPdfRequestStream.Info.Builder info = ImageFilesToPdfRequestStream.Info.newBuilder();
        info.setRenderOptions(Render_Converter.toProto(renderOptions != null ? renderOptions : new ChromePdfRenderOptions()));
        info.setImageBehavior(Image_Converter.toProto(imageBehavior));
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResult> resultChunks = new ArrayList<PdfDocumentResult>();
        StreamObserver<ImageFilesToPdfRequestStream> requestStream = client.stub.pdfDocumentImageImageFilesToPdf(new Utils_ReceivingCustomStreamObserver<PdfDocumentResult>(finishLatch, resultChunks));
        ImageFilesToPdfRequestStream.Builder infoMsg = ImageFilesToPdfRequestStream.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        for (int imageIndex : IntStream.range(0, imagesData.size()).toArray()) {
            ImageData imageData = imagesData.get(imageIndex);
            Iterator<byte[]> it = Utils_Util.chunk(imageData.data);
            while (it.hasNext()) {
                byte[] chunk = it.next();
                ImageFilesToPdfRequestStream.Builder msg = ImageFilesToPdfRequestStream.newBuilder();
                RawImageChunkWithIndexAndFileType.Builder rawImageFilesChunkWithIndex = RawImageChunkWithIndexAndFileType.newBuilder();
                rawImageFilesChunkWithIndex.setRawImageChunk(ByteString.copyFrom((byte[])chunk));
                rawImageFilesChunkWithIndex.setImageIndex(imageIndex);
                rawImageFilesChunkWithIndex.setFileType(imageData.fileExtension);
                msg.setRawImagesFileChunk(rawImageFilesChunkWithIndex);
                requestStream.onNext((Object)msg.build());
            }
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static void drawImage(InternalPdfDocument internalPdfDocument, byte[] imageBytes, Iterable<Integer> pageIndexes, double x, double y, double desiredWidth, double desiredHeight) {
        RpcClient client = Access.ensureConnection();
        DrawBitmapRequestStream.Info.Builder info = DrawBitmapRequestStream.Info.newBuilder();
        info.setDocument(internalPdfDocument.remoteDocument);
        info.setX(x);
        info.setY(y);
        info.setDesiredWidth(desiredWidth);
        info.setDesiredHeight(desiredHeight);
        info.addAllPageIndexes(pageIndexes);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<EmptyResult> resultChunks = new ArrayList<EmptyResult>();
        StreamObserver<DrawBitmapRequestStream> requestStream = client.stub.pdfDocumentImageDrawBitmap(new Utils_ReceivingCustomStreamObserver<EmptyResult>(finishLatch, resultChunks));
        requestStream.onNext((Object)DrawBitmapRequestStream.newBuilder().setInfo(info).build());
        Iterator<byte[]> it = Utils_Util.chunk(imageBytes);
        while (it.hasNext()) {
            byte[] bytes = it.next();
            DrawBitmapRequestStream.Builder msg = DrawBitmapRequestStream.newBuilder();
            msg.setRawImageChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)msg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        Utils_Util.handleEmptyResultChunks(resultChunks);
    }

    public static List<byte[]> extractAllImages(InternalPdfDocument internalPdfDocument) throws IOException {
        return Image_Api.extractAllImages(internalPdfDocument, null);
    }

    public static List<byte[]> extractAllImages(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes) throws IOException {
        RpcClient client = Access.ensureConnection();
        ExtractAllRawImagesRequest.Builder request = ExtractAllRawImagesRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        if (pageIndexes != null) {
            request.addAllPageIndexes(pageIndexes);
        }
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<ImagesResultStream> resultChunks = new ArrayList<ImagesResultStream>();
        client.stub.pdfDocumentImageExtractAllRawImages(request.build(), new Utils_ReceivingCustomStreamObserver<ImagesResultStream>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleImagesResult(resultChunks);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes, int dpi, Integer imageMaxWidth) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, pageIndexes, dpi, imageMaxWidth, null);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes, int dpi, Integer imageMaxWidth, Integer imageMaxHeight) throws IOException {
        RpcClient client = Access.ensureConnection();
        PdfToImagesRequest.Builder request = PdfToImagesRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setDpi(dpi);
        if (pageIndexes != null) {
            request.addAllPageIndexes(pageIndexes);
        }
        if (imageMaxWidth != null) {
            request.setMaxWidth(imageMaxWidth);
        }
        if (imageMaxHeight != null) {
            request.setMaxHeight(imageMaxHeight);
        }
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<ImagesResultStream> resultChunks = new ArrayList<ImagesResultStream>();
        client.stub.pdfDocumentImagePdfToImages(request.build(), new Utils_ReceivingCustomStreamObserver<ImagesResultStream>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleImagesResult(resultChunks);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes, int dpi) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, pageIndexes, dpi, null, null);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, pageIndexes, 92, null, null);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, null, 92, null, null);
    }

    public static byte[] toMultiPageTiff(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes, int dpi, Integer imageMaxWidth, Integer imageMaxHeight) throws IOException {
        RpcClient client = Access.ensureConnection();
        PdfToMultiPageTiffImageRequest.Builder request = PdfToMultiPageTiffImageRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setDpi(dpi);
        if (pageIndexes != null) {
            request.addAllPageIndexes(pageIndexes);
        }
        if (imageMaxWidth != null) {
            request.setMaxWidth(imageMaxWidth);
        }
        if (imageMaxHeight != null) {
            request.setMaxHeight(imageMaxHeight);
        }
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<ImageResultStream> resultChunks = new ArrayList<ImageResultStream>();
        client.stub.pdfDocumentImagePdfToMultiPageTiffImage(request.build(), new Utils_ReceivingCustomStreamObserver<ImageResultStream>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleImageResult(resultChunks);
    }

    public static class ImageData {
        byte[] data;
        String fileExtension;

        public ImageData(byte[] data, String fileExtension) {
            this.data = data;
            this.fileExtension = fileExtension;
        }
    }
}

