/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.font.FontTypes;
import com.ironsoftware.ironpdf.form.FormField;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.FlattenFormRequest;
import com.ironsoftware.ironpdf.internal.proto.GetFormRequest;
import com.ironsoftware.ironpdf.internal.proto.GetFormResult;
import com.ironsoftware.ironpdf.internal.proto.RenameFieldRequest;
import com.ironsoftware.ironpdf.internal.proto.SetFormFieldIsReadOnlyRequest;
import com.ironsoftware.ironpdf.internal.proto.SetFromFieldFontRequest;
import com.ironsoftware.ironpdf.internal.proto.SetFromFieldValueRequest;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.FontTypes_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Form_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import java.util.List;

public final class Form_Api {
    public static List<FormField> getFields(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        GetFormRequest.Builder request = GetFormRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        GetFormResult response = client.blockingStub.pdfDocumentFormGetForm(request.build());
        if (response.getResultOrExceptionCase() == GetFormResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(response.getException());
        }
        return Form_Converter.fromProto(response.getResult());
    }

    public static void renameField(InternalPdfDocument internalPdfDocument, String currentFieldName, String newFieldName) {
        RpcClient client = Access.ensureConnection();
        RenameFieldRequest.Builder request = RenameFieldRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setCurrentFieldName(currentFieldName);
        request.setNewFieldName(newFieldName);
        EmptyResult response = client.blockingStub.pdfDocumentFormRenameField(request.build());
        Utils_Util.handleEmptyResult(response);
    }

    public static void setFieldValue(InternalPdfDocument internalPdfDocument, String fieldName, String value) {
        RpcClient client = Access.ensureConnection();
        SetFromFieldValueRequest.Builder request = SetFromFieldValueRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setFieldName(fieldName);
        request.setFormFieldValue(value);
        EmptyResult response = client.blockingStub.pdfDocumentFormSetFieldValue(request.build());
        Utils_Util.handleEmptyResult(response);
    }

    public static void setTextFieldFont(InternalPdfDocument internalPdfDocument, String textFieldName, FontTypes font, int fontSize) {
        RpcClient client = Access.ensureConnection();
        SetFromFieldFontRequest.Builder request = SetFromFieldFontRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setFieldName(textFieldName);
        request.setFontType(FontTypes_Converter.toProto(font));
        request.setFontSize(fontSize);
        EmptyResult response = client.blockingStub.pdfDocumentFormSetFieldFont(request.build());
        Utils_Util.handleEmptyResult(response);
    }

    public static void flattenPdfFrom(InternalPdfDocument internalPdfDocument) {
        Form_Api.flattenPdfFrom(internalPdfDocument, null);
    }

    public static void flattenPdfFrom(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        FlattenFormRequest.Builder req = FlattenFormRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        if (pageIndexes != null) {
            req.addAllPageIndexes(pageIndexes);
        }
        EmptyResult res = client.blockingStub.pdfDocumentFormFlattenForm(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void setFormFieldIsReadOnly(InternalPdfDocument internalPdfDocument, String formFieldName, boolean isReadOnly) {
        RpcClient client = Access.ensureConnection();
        SetFormFieldIsReadOnlyRequest.Builder request = SetFormFieldIsReadOnlyRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setFieldName(formFieldName);
        request.setIsReadOnly(isReadOnly);
        EmptyResult response = client.blockingStub.pdfDocumentFormSetFormFieldIsReadOnly(request.build());
        Utils_Util.handleEmptyResult(response);
    }
}

