/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.Settings;
import com.ironsoftware.ironpdf.internal.proto.HandshakeRequest;
import com.ironsoftware.ironpdf.internal.proto.HandshakeResponse;
import com.ironsoftware.ironpdf.internal.proto.IronPdfServiceGrpc;
import com.ironsoftware.ironpdf.internal.staticapi.ConfigLoader;
import com.ironsoftware.ironpdf.internal.staticapi.DownloadInputStream;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.License_Api;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Setting_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Access {
    static final Logger logger = LoggerFactory.getLogger(Access.class);
    static final Logger engineLogger = LoggerFactory.getLogger((String)"com.ironsoftware.ironpdf.IronPdfEngine");
    static RpcClient client = null;
    static boolean isTryDownloaded = false;
    private static ManagedChannel channel = null;
    private static Process ironPdfProcess = null;
    private static boolean tryAgain = true;
    private static BufferedReader stdInput;
    private static BufferedReader stdError;
    private static CountDownLatch serverReady;

    Access() {
    }

    static synchronized RpcClient ensureConnection() {
        if (client != null) {
            return client;
        }
        if (!Setting_Api.isIronPdfEngineDocker) {
            Access.startServer();
        }
        if (channel == null) {
            channel = ManagedChannelBuilder.forAddress((String)Setting_Api.subProcessHost, (int)Setting_Api.subProcessPort).usePlaintext().build();
        }
        RpcClient newClient = new RpcClient(IronPdfServiceGrpc.newBlockingStub((Channel)channel), IronPdfServiceGrpc.newFutureStub((Channel)channel), IronPdfServiceGrpc.newStub((Channel)channel));
        logger.debug("Handshaking, Expected IronPdfEngine Version : 2023.5.1");
        HandshakeRequest.Builder handshakeRequest = HandshakeRequest.newBuilder();
        handshakeRequest.setExpectedVersion("2023.5.1");
        handshakeRequest.setProgLang("java");
        HandshakeResponse res_firstTry = newClient.blockingStub.handshake(handshakeRequest.build());
        logger.debug("Handshake result:" + res_firstTry);
        switch (res_firstTry.getResultOrExceptionCase()) {
            case SUCCESS: {
                client = newClient;
                Access.setLicenseKey();
                return client;
            }
            case REQUIREDVERSION: {
                logger.error("Mismatch IronPdfEngine version expected: 2023.5.1 but found:" + res_firstTry);
                if (!Setting_Api.isIronPdfEngineDocker && tryAgain) {
                    tryAgain = false;
                    Access.stopIronPdfEngine();
                    Access.downloadIronPdfEngine();
                    Setting_Api.subProcessPort = Setting_Api.getDefaultPort();
                    return Access.ensureConnection();
                }
                client = newClient;
                Access.setLicenseKey();
                return client;
            }
            case EXCEPTION: {
                throw Exception_Converter.fromProto(res_firstTry.getException());
            }
        }
        throw new RuntimeException("Unexpected result from handshake");
    }

    static void setLicenseKey() {
        String lk;
        String string = lk = Utils_StringHelper.isNullOrWhiteSpace(Setting_Api.licenseKey) ? new ConfigLoader().getProperty("IRONPDF_LICENSE_KEY") : Setting_Api.licenseKey;
        if (!Utils_StringHelper.isNullOrWhiteSpace(lk)) {
            License_Api.SetLicensed(lk);
        }
    }

    static synchronized void downloadIronPdfEngine() {
        try {
            if (isTryDownloaded) {
                return;
            }
            Path zipFilePath = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineZipName());
            Utils_Util.logInfoOrSystemOut(logger, "Download IronPdfEngine to working dir: " + zipFilePath.toAbsolutePath());
            isTryDownloaded = true;
            URL downloadUrl = new URL("https://ironpdfengine.azurewebsites.net/api/IronPdfEngineDownload?version=2023.5.1&platform=" + Setting_Api.currentOsFullName() + "&architect=" + Setting_Api.currentOsArch());
            try (InputStream stream = downloadUrl.openStream();){
                long downloadSize = stream.available();
                try (DownloadInputStream pis = new DownloadInputStream(stream, downloadSize, logger);){
                    FileUtils.copyInputStreamToFile((InputStream)pis, (File)zipFilePath.toFile());
                }
            }
            Path unzippedFolder = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFolderName());
            Utils_Util.logInfoOrSystemOut(logger, "Unzipping IronPdfEngine to dir: " + unzippedFolder);
            Access.unzip(zipFilePath.toAbsolutePath().toString(), unzippedFolder.toAbsolutePath().toString());
            logger.info("Delete zip file: " + zipFilePath.toAbsolutePath());
            Files.deleteIfExists(zipFilePath.toAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to download IronPdfEngine binary", (Throwable)e);
            throw new RuntimeException("Failed to download IronPdfEngine binary", e);
        }
    }

    static void unzip(String zipFilePath, String destDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(entryDestination.toPath(), new FileAttribute[0]);
                    Access.setPermission(entryDestination);
                    continue;
                }
                File parentDir = entryDestination.getParentFile();
                Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
                Access.setPermission(parentDir);
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    OutputStream out = Files.newOutputStream(entryDestination.toPath(), new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    static synchronized void startServer() {
        block11: {
            try {
                Optional<File> selectedFile = Access.getAvailableIronPdfEngineFile();
                if (selectedFile.isPresent()) {
                    logger.info("Using IronPdfEngine from: " + selectedFile.get().getAbsolutePath());
                    try {
                        try {
                            File parentDir = selectedFile.get().getParentFile();
                            Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
                            Access.setPermission(parentDir);
                        }
                        catch (Exception e) {
                            logger.warn("Cannot set IronPdfEngine parent folder permission ", (Throwable)e);
                        }
                        Arrays.stream((Object[])Objects.requireNonNull(selectedFile.get().getParentFile().listFiles())).forEach(file -> {
                            try {
                                Access.setPermission(file);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.warn("Cannot set IronPdfEngine files permission ", (Throwable)e);
                    }
                    ArrayList<String> cmdList = new ArrayList<String>();
                    cmdList.add(selectedFile.get().toPath().toAbsolutePath().toString());
                    cmdList.add(String.format("host=%1$s", Setting_Api.subProcessHost));
                    cmdList.add(String.format("port=%1$s", Setting_Api.subProcessPort));
                    cmdList.add(String.format("enable_debug=%1$s", Setting_Api.enableDebug));
                    cmdList.add(String.format("log_path=%1$s", Setting_Api.logPath));
                    cmdList.add(String.format("programming_language=%1$s", "java"));
                    if (Setting_Api.tempFolderPath != null) {
                        cmdList.add(String.format("temp_folder_path=%1$s", Setting_Api.tempFolderPath.toAbsolutePath()));
                    }
                    if (!Utils_StringHelper.isNullOrWhiteSpace(Setting_Api.licenseKey)) {
                        cmdList.add(String.format("license_key=%1$s", Setting_Api.licenseKey));
                    } else {
                        cmdList.add(String.format("license_key=%1$s", new ConfigLoader().getProperty("IRONPDF_LICENSE_KEY")));
                    }
                    serverReady = new CountDownLatch(1);
                    ProcessBuilder pb = new ProcessBuilder(cmdList);
                    logger.info("Start IronPdfEngine");
                    Process proc = pb.start();
                    Access.catchServerMessage(proc);
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        Access.shutdownChanel();
                        logger.info("Shutdown IronPdfEngine process");
                        proc.destroy();
                    }));
                    boolean ignored = serverReady.await(60L, TimeUnit.SECONDS);
                    ironPdfProcess = proc;
                    break block11;
                }
                logger.debug("Cannot find IronPdfEngine from ironPdf working dir:" + Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath());
                if (tryAgain) {
                    Access.downloadIronPdfEngine();
                    logger.info("Try to start IronPdfEngine again");
                    tryAgain = false;
                    Access.startServer();
                    break block11;
                }
                throw new RuntimeException(String.format("Cannot locate IronPdfEngine. at %1$s", Setting_Api.getIronPdfEngineExecutablePath(Setting_Api.ironPdfEngineWorkingDirectory).toAbsolutePath()) + " An alternative approach is to install one of ironpdf-engine packages https://search.maven.org/search?q=ironpdf%20engine, more information: https://github.com/iron-software/IronPDF-for-Java#install-ironpdf-engine-as-a-maven-dependency");
            }
            catch (Exception e) {
                logger.error("Cannot start IronPdfEngine (working dir: " + Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath() + ")", (Throwable)e);
                e.printStackTrace();
                throw new RuntimeException("Cannot start IronPdfEngine due to " + e.getMessage(), e);
            }
        }
    }

    private static void catchServerMessage(Process proc) {
        stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        Thread threadInput = new Thread(() -> {
            engineLogger.debug("listening IronPdfEngine");
            stdInput.lines().forEach(line -> {
                if (line.trim().equalsIgnoreCase("IronPdfEngine is up")) {
                    serverReady.countDown();
                }
                if (Setting_Api.enableDebug) {
                    engineLogger.info("[IronPdfEngine]" + line);
                }
            });
        });
        threadInput.setDaemon(true);
        threadInput.start();
        stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        Thread threadError = new Thread(() -> stdError.lines().forEach(line -> {
            if (Setting_Api.enableDebug) {
                engineLogger.error("[IronPdfEngine][Error]" + line);
            } else {
                Settings.setDebug(true);
                logger.warn("IronPdfEngine Error! For more information, Please enable Debug mode by adding this line before calling any IronPDF methods `com.ironsoftware.ironpdf.Settings.setDebug(true);`");
                logger.info("Current log file path: " + Setting_Api.logPath.toAbsolutePath());
            }
        }));
        threadError.setDaemon(true);
        threadError.start();
    }

    private static void shutdownChanel() {
        if (channel != null && !channel.isShutdown() && !channel.isTerminated()) {
            channel.shutdown();
            channel = null;
        }
    }

    public static void stopIronPdfEngine() {
        Access.shutdownChanel();
        if (ironPdfProcess != null) {
            ironPdfProcess.destroy();
        }
        ironPdfProcess = null;
        client = null;
    }

    private static void setPermission(File file) {
        try {
            boolean setExecutablePermissionResult = file.setExecutable(true, false);
            boolean setWritablePermissionResult = file.setWritable(true, false);
            boolean setReadablePermissionResult = file.setReadable(true, false);
            logger.debug(file.getAbsolutePath() + " permission status:" + System.lineSeparator() + " Executable:" + setExecutablePermissionResult + System.lineSeparator() + " Writable:" + setWritablePermissionResult + System.lineSeparator() + " Readable:" + setReadablePermissionResult);
        }
        catch (Exception exception) {
            logger.warn("Set permission failed : " + file.getAbsolutePath(), (Throwable)exception);
        }
    }

    private static Optional<File> getAvailableIronPdfEngineFile() {
        Path binFromWorkingDir = Setting_Api.getIronPdfEngineExecutablePath(Setting_Api.ironPdfEngineWorkingDirectory);
        try {
            if (Files.exists(binFromWorkingDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + binFromWorkingDir);
                return Optional.of(binFromWorkingDir.toFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("IronPdfEngine not found at IronPdfEngine working directory: " + binFromWorkingDir.toAbsolutePath());
        try {
            String engineResourceClassName = "com.ironsoftware.ironpdf.internal.EngineResource" + Setting_Api.currentOsFullName() + Setting_Api.currentOsArch();
            try (InputStream inputStream = Class.forName(engineResourceClassName).getResourceAsStream("/" + Setting_Api.getIronPdfEngineFolderName() + ".zip");){
                Path zipFilePath = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFolderName() + ".zip");
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)zipFilePath.toFile());
                Path unzipTargetPath = Paths.get(Setting_Api.ironPdfEngineWorkingDirectory.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFolderName() + "/");
                Utils_Util.logInfoOrSystemOut(logger, "Unzipping IronPdfEngine (from dependency) to dir: " + unzipTargetPath);
                Access.unzip(zipFilePath.toAbsolutePath().toString(), unzipTargetPath.toAbsolutePath().toString());
                Files.deleteIfExists(zipFilePath.toAbsolutePath());
            }
            if (Files.exists(binFromWorkingDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found (extracted from ironpdf-engine package) (EngineResource) at: " + binFromWorkingDir);
                return Optional.of(binFromWorkingDir.toFile());
            }
        }
        catch (ClassNotFoundException ignored) {
            logger.debug("Cannot detect IronPdfEngine from ironpdf-engine package, skipped");
        }
        catch (Exception e) {
            logger.debug("IronPdfEngine from ironpdf-engine package not found", (Throwable)e);
        }
        Path binFromUserDir = Setting_Api.getIronPdfEngineExecutablePath(Paths.get(System.getProperty("user.dir"), new String[0]));
        try {
            if (Files.exists(binFromUserDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + binFromUserDir);
                return Optional.of(binFromUserDir.toFile());
            }
        }
        catch (Exception inputStream) {
            // empty catch block
        }
        logger.debug("IronPdfEngine not found at: (System.getProperty(\"user.dir\")): " + binFromUserDir.toAbsolutePath());
        Path binFromCurrentDir = Setting_Api.getIronPdfEngineExecutablePath(Paths.get(".", new String[0]));
        try {
            if (Files.exists(binFromCurrentDir, new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + binFromCurrentDir);
                return Optional.of(binFromCurrentDir.toFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("IronPdfEngine not found at current dir: " + binFromCurrentDir.toAbsolutePath());
        return Optional.empty();
    }
}

