/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf;

import com.ironsoftware.ironpdf.annotation.AnnotationManager;
import com.ironsoftware.ironpdf.attachment.AttachmentManager;
import com.ironsoftware.ironpdf.bookmark.BookmarkManager;
import com.ironsoftware.ironpdf.edit.PageSelection;
import com.ironsoftware.ironpdf.form.FormManager;
import com.ironsoftware.ironpdf.headerfooter.HeaderFooterOptions;
import com.ironsoftware.ironpdf.headerfooter.HtmlHeaderFooter;
import com.ironsoftware.ironpdf.headerfooter.TextHeaderFooter;
import com.ironsoftware.ironpdf.image.DrawImageOptions;
import com.ironsoftware.ironpdf.image.ImageBehavior;
import com.ironsoftware.ironpdf.image.ToImageOptions;
import com.ironsoftware.ironpdf.internal.staticapi.BackgroundForeground_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Compress_Api;
import com.ironsoftware.ironpdf.internal.staticapi.HeaderFooter_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Image_Api;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Api;
import com.ironsoftware.ironpdf.internal.staticapi.PdfDocument_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Print_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Render_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Stamp_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Text_Api;
import com.ironsoftware.ironpdf.metadata.MetadataManager;
import com.ironsoftware.ironpdf.page.PageInfo;
import com.ironsoftware.ironpdf.page.PageRotation;
import com.ironsoftware.ironpdf.render.ChromeHttpLoginCredentials;
import com.ironsoftware.ironpdf.render.ChromePdfRenderOptions;
import com.ironsoftware.ironpdf.render.PaperSize;
import com.ironsoftware.ironpdf.security.SecurityManager;
import com.ironsoftware.ironpdf.signature.SignatureManager;
import com.ironsoftware.ironpdf.stamp.HorizontalAlignment;
import com.ironsoftware.ironpdf.stamp.HtmlStamper;
import com.ironsoftware.ironpdf.stamp.Stamper;
import com.ironsoftware.ironpdf.stamp.VerticalAlignment;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDocument
implements Printable {
    static final Logger logger = LoggerFactory.getLogger(PdfDocument.class);
    private final InternalPdfDocument internalPdfDocument;
    private final BookmarkManager bookmarkManager;
    private final MetadataManager metadataManager;
    private final AnnotationManager annotationManager;
    private final FormManager formManager;
    private final AttachmentManager attachmentManager;
    private final SecurityManager securityManager;
    private final SignatureManager signatureManager;

    private PdfDocument(InternalPdfDocument static_pdfDocument) {
        this.internalPdfDocument = static_pdfDocument;
        this.bookmarkManager = new BookmarkManager(this.internalPdfDocument);
        this.metadataManager = new MetadataManager(this.internalPdfDocument);
        this.annotationManager = new AnnotationManager(this.internalPdfDocument);
        this.formManager = new FormManager(this.internalPdfDocument);
        this.attachmentManager = new AttachmentManager(this.internalPdfDocument);
        this.securityManager = new SecurityManager(this.internalPdfDocument);
        this.signatureManager = new SignatureManager(this.internalPdfDocument);
    }

    public PdfDocument(Path pdfFilePath, String password) throws IOException {
        this(pdfFilePath, password, "");
    }

    public PdfDocument(Path pdfFilePath, String password, String ownerPassword) throws IOException {
        this(Files.readAllBytes(pdfFilePath), password, ownerPassword);
    }

    public PdfDocument(byte[] pdfData, String password, String ownerPassword) {
        this(PdfDocument_Api.fromBytes(pdfData, password, ownerPassword));
    }

    public PdfDocument(Path pdfFilePath) throws IOException {
        this(pdfFilePath, "", "");
    }

    public PdfDocument(byte[] pdfData, String password) {
        this(pdfData, password, "");
    }

    public PdfDocument(byte[] pdfData) {
        this(pdfData, "", "");
    }

    public static PdfDocument fromFile(Path pdfFilePath, String password) throws IOException {
        return PdfDocument.fromFile(pdfFilePath, password, "");
    }

    public static PdfDocument fromFile(Path pdfFilePath, String password, String ownerPassword) throws IOException {
        return new PdfDocument(pdfFilePath, password, ownerPassword);
    }

    public static PdfDocument fromFile(Path pdfFilePath) throws IOException {
        return PdfDocument.fromFile(pdfFilePath, "", "");
    }

    public static PdfDocument fromImage(List<Path> imagesPath) {
        return PdfDocument.fromImage(imagesPath, ImageBehavior.CENTERED_ON_PAGE);
    }

    public static PdfDocument fromImage(List<Path> imagesPath, PaperSize paperSize) {
        return PdfDocument.fromImage(imagesPath, ImageBehavior.CENTERED_ON_PAGE, paperSize);
    }

    public static PdfDocument fromImage(List<Path> imagesPath, ImageBehavior imageBehavior) {
        return PdfDocument.fromImage(imagesPath, imageBehavior, (ChromePdfRenderOptions)null);
    }

    public static PdfDocument fromImage(List<Path> imagesPath, ImageBehavior imageBehavior, PaperSize paperSize) {
        ChromePdfRenderOptions renderOption = new ChromePdfRenderOptions();
        renderOption.setPaperSize(paperSize);
        return PdfDocument.fromImage(imagesPath, imageBehavior, renderOption);
    }

    public static PdfDocument fromImage(List<Path> imagesPath, ImageBehavior imageBehavior, ChromePdfRenderOptions renderOptions) {
        List<Image_Api.ImageData> imageDataList = imagesPath.stream().map(x -> {
            try {
                return new Image_Api.ImageData(Files.readAllBytes(x), FilenameUtils.getExtension((String)x.toAbsolutePath().toString()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return new PdfDocument(Image_Api.imageToPdf(imageDataList, imageBehavior, renderOptions));
    }

    public BookmarkManager getBookmark() {
        return this.bookmarkManager;
    }

    public MetadataManager getMetadata() {
        return this.metadataManager;
    }

    public AnnotationManager getAnnotation() {
        return this.annotationManager;
    }

    public FormManager getForm() {
        return this.formManager;
    }

    public AttachmentManager getAttachment() {
        return this.attachmentManager;
    }

    public SecurityManager getSecurity() {
        return this.securityManager;
    }

    public SignatureManager getSignature() {
        return this.signatureManager;
    }

    public static PdfDocument merge(PdfDocument A, PdfDocument B) {
        return PdfDocument.merge(Arrays.asList(A, B));
    }

    public static PdfDocument merge(List<PdfDocument> Documents) {
        return new PdfDocument(Page_Api.mergePage(Documents.stream().map(x -> x.internalPdfDocument).collect(Collectors.toList())));
    }

    public final PdfDocument copyPage(int PageIndex) {
        return this.copyPages(new ArrayList<Integer>(Collections.singletonList(PageIndex)));
    }

    public final PdfDocument copyPages(Iterable<Integer> PageIndexes) {
        return new PdfDocument(Page_Api.copyPage(this.internalPdfDocument, PageIndexes));
    }

    public final PdfDocument copyPages(int StartIndex, int EndIndex) {
        ArrayList<Integer> pageIndexes = new ArrayList<Integer>();
        for (int i = StartIndex; i <= EndIndex; ++i) {
            pageIndexes.add(i);
        }
        return this.copyPages(pageIndexes);
    }

    public final PdfDocument appendPdf(PdfDocument AnotherPdfFile) {
        Page_Api.appendPdf(this.internalPdfDocument, AnotherPdfFile.internalPdfDocument);
        return this;
    }

    public final PdfDocument insertPdf(PdfDocument AnotherPdfFile) {
        return this.insertPdf(AnotherPdfFile, 0);
    }

    public final PdfDocument insertPdf(PdfDocument AnotherPdfFile, int AtIndex) {
        Page_Api.insertPage(this.internalPdfDocument, AnotherPdfFile.internalPdfDocument, AtIndex);
        return this;
    }

    public final PdfDocument prependPdf(PdfDocument AnotherPdfFile) {
        Page_Api.insertPage(this.internalPdfDocument, AnotherPdfFile.internalPdfDocument, 0);
        return this;
    }

    public final PdfDocument removePages(PageSelection pageSelection) {
        Page_Api.removePage(this.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection));
        return this;
    }

    public final List<PageInfo> getPagesInfo() {
        return Page_Api.getPagesInfo(this.internalPdfDocument);
    }

    public final Map<Integer, PageInfo> getPagesInfo(PageSelection pageSelection) {
        List<PageInfo> pagesInfo = Page_Api.getPagesInfo(this.internalPdfDocument);
        return this.internalPdfDocument.getPageList(pageSelection).stream().collect(Collectors.toMap(x -> x, pagesInfo::get));
    }

    public final void rotateAllPages(PageRotation rotation) {
        Page_Api.setPageRotation(this.internalPdfDocument, rotation);
    }

    public final void rotatePage(PageRotation pageRotation, PageSelection pageSelection) {
        Page_Api.setPageRotation(this.internalPdfDocument, pageRotation, this.internalPdfDocument.getPageList(pageSelection));
    }

    public final void resizePage(double pageWidth, double pageHeight, PageSelection pageSelection) {
        this.internalPdfDocument.getPageList(pageSelection).forEach(x -> Page_Api.resizePage(this.internalPdfDocument, pageWidth, pageHeight, x));
    }

    public final PdfDocument addBackgroundPdf(PdfDocument backgroundPdf) {
        return this.addBackgroundPdf(backgroundPdf, 0, PageSelection.allPages());
    }

    public final PdfDocument addBackgroundPdf(PdfDocument backgroundPdf, int backgroundPdfPageIndex) {
        return this.addBackgroundPdf(backgroundPdf, backgroundPdfPageIndex, PageSelection.allPages());
    }

    public final PdfDocument addBackgroundPdf(PdfDocument backgroundPdf, PageSelection pageSelection) {
        BackgroundForeground_Api.addBackground(this.internalPdfDocument, backgroundPdf.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection));
        return this;
    }

    public final PdfDocument addBackgroundPdf(PdfDocument backgroundPdf, int backgroundPdfPageIndex, PageSelection pageSelection) {
        BackgroundForeground_Api.addBackground(this.internalPdfDocument, backgroundPdf.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection), backgroundPdfPageIndex);
        return this;
    }

    public final PdfDocument addForegroundPdf(PdfDocument foregroundPdf) {
        return this.addForegroundPdf(foregroundPdf, 0, PageSelection.allPages());
    }

    public final PdfDocument addForegroundPdf(PdfDocument foregroundPdf, int foregroundPdfPageIndex) {
        return this.addForegroundPdf(foregroundPdf, foregroundPdfPageIndex, PageSelection.allPages());
    }

    public final PdfDocument addForegroundPdf(PdfDocument foregroundPdf, PageSelection pageSelection) {
        return this.addForegroundPdf(foregroundPdf, 0, pageSelection);
    }

    public final PdfDocument addForegroundPdf(PdfDocument foregroundPdf, int foregroundPdfPageIndex, PageSelection pageSelection) {
        BackgroundForeground_Api.addForeground(this.internalPdfDocument, foregroundPdf.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection), foregroundPdfPageIndex);
        return this;
    }

    public PdfDocument addTextHeader(TextHeaderFooter header) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addTextHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addTextHeader(TextHeaderFooter header, PageSelection pageSelection) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addTextHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addTextHeader(TextHeaderFooter header, HeaderFooterOptions headerFooterOptions) {
        HeaderFooter_Api.addTextHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addTextHeader(TextHeaderFooter header, HeaderFooterOptions headerFooterOptions, PageSelection pageSelection) {
        HeaderFooter_Api.addTextHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addTextFooter(TextHeaderFooter footer) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addTextFooter(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addTextFooter(TextHeaderFooter footer, PageSelection pageSelection) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addTextFooter(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addTextFooter(TextHeaderFooter footer, HeaderFooterOptions headerFooterOptions) {
        HeaderFooter_Api.addTextFooter(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addTextFooter(TextHeaderFooter footer, HeaderFooterOptions headerFooterOptions, PageSelection pageSelection) {
        HeaderFooter_Api.addTextFooter(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getPdfTitle());
        return this;
    }

    public PdfDocument addHtmlHeader(HtmlHeaderFooter header) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addHtmlHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public PdfDocument addHtmlHeader(HtmlHeaderFooter header, PageSelection pageSelection) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addHtmlHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public PdfDocument addHtmlHeader(HtmlHeaderFooter header, HeaderFooterOptions headerFooterOptions) {
        HeaderFooter_Api.addHtmlHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public PdfDocument addHtmlHeader(HtmlHeaderFooter header, HeaderFooterOptions headerFooterOptions, PageSelection pageSelection) {
        HeaderFooter_Api.addHtmlHeader(this.internalPdfDocument, header, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public PdfDocument addHtmlFooter(HtmlHeaderFooter footer) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addHtmlFooter(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public PdfDocument addHtmlFooter(HtmlHeaderFooter footer, PageSelection pageSelection) {
        HeaderFooterOptions headerFooterOptions = new HeaderFooterOptions();
        HeaderFooter_Api.addHtmlFooter(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public PdfDocument addHtmlFooter(HtmlHeaderFooter footer, HeaderFooterOptions headerFooterOptions) {
        HeaderFooter_Api.addHtmlHeader(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(PageSelection.allPages()), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public PdfDocument addHtmlFooter(HtmlHeaderFooter footer, HeaderFooterOptions headerFooterOptions, PageSelection pageSelection) {
        HeaderFooter_Api.addHtmlHeader(this.internalPdfDocument, footer, headerFooterOptions.getFirstPageNumber(), this.internalPdfDocument.getPageList(pageSelection), headerFooterOptions.getMarginLeftMm(), headerFooterOptions.getMarginRightMm(), headerFooterOptions.getMarginTopMm(), headerFooterOptions.getMarginBottomMm(), headerFooterOptions.getRenderPdfCssMediaType(), headerFooterOptions.getPdfTitle(), headerFooterOptions.getHtmlTitle());
        return this;
    }

    public final void drawImage(Path imagePath, DrawImageOptions option) throws IOException {
        Image_Api.drawImage(this.internalPdfDocument, Files.readAllBytes(imagePath), this.internalPdfDocument.getPageList(option.getPageSelection()), option.getX(), option.getY(), option.getWidth(), option.getHeight());
    }

    public final void drawImage(byte[] imageBytes, DrawImageOptions option) {
        Image_Api.drawImage(this.internalPdfDocument, imageBytes, this.internalPdfDocument.getPageList(option.getPageSelection()), option.getX(), option.getY(), option.getWidth(), option.getHeight());
    }

    public final List<BufferedImage> toBufferedImages() throws IOException {
        return this.toBufferedImages(new ToImageOptions());
    }

    public final List<BufferedImage> toBufferedImages(ToImageOptions options) throws IOException {
        return this.toBufferedImages(options, PageSelection.allPages());
    }

    public final List<BufferedImage> toBufferedImages(PageSelection pageSelection) throws IOException {
        return this.toBufferedImages(new ToImageOptions(), pageSelection);
    }

    public final List<BufferedImage> toBufferedImages(ToImageOptions options, PageSelection pageSelection) throws IOException {
        return Image_Api.pdfToImage(this.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection), options.getDpi(), options.getImageMaxWidth(), options.getImageMaxHeight()).stream().map(bytes -> {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])bytes);
            try {
                return ImageIO.read(byteArrayInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public final List<String> toPngImages(String fileNamePattern) throws IOException {
        return this.toPngImages(fileNamePattern, new ToImageOptions(), PageSelection.allPages());
    }

    public final List<String> toPngImages(String fileNamePattern, ToImageOptions options) throws IOException {
        return this.toPngImages(fileNamePattern, options, PageSelection.allPages());
    }

    public final List<String> toPngImages(String fileNamePattern, PageSelection pageSelection) throws IOException {
        return this.toPngImages(fileNamePattern, new ToImageOptions(), pageSelection);
    }

    public final List<String> toPngImages(String fileNamePattern, ToImageOptions options, PageSelection pageSelection) throws IOException {
        return this.toImages(fileNamePattern, "png", options, pageSelection);
    }

    public List<String> toImages(String fileNamePattern, String imageFileType) throws IOException {
        return this.toImages(fileNamePattern, imageFileType, new ToImageOptions());
    }

    public List<String> toImages(String fileNamePattern, String imageFileType, ToImageOptions options) throws IOException {
        return this.toImages(fileNamePattern, imageFileType, options, PageSelection.allPages());
    }

    public List<String> toImages(String fileNamePattern, String imageFileType, PageSelection pageSelection) throws IOException {
        return this.toImages(fileNamePattern, imageFileType, new ToImageOptions(), pageSelection);
    }

    public List<String> toImages(String fileNamePattern, String imageFileType, ToImageOptions options, PageSelection pageSelection) throws IOException {
        List<byte[]> dataList = Image_Api.pdfToImage(this.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection), options.getDpi(), options.getImageMaxWidth(), options.getImageMaxHeight());
        ArrayList<String> paths = new ArrayList<String>();
        int imageIndex = 1;
        for (byte[] data : dataList) {
            if (imageFileType == null || imageFileType.isEmpty()) {
                imageFileType = FilenameUtils.getExtension((String)fileNamePattern);
            }
            String file_nam = FilenameUtils.getBaseName((String)fileNamePattern);
            String file_ext = FilenameUtils.getExtension((String)fileNamePattern);
            String file_dir = new File(fileNamePattern).getParent();
            String file_new = file_nam;
            int current_index = imageIndex++;
            if (file_nam.contains("*")) {
                file_new = file_nam.replace("*", String.format("%1$s", current_index));
            } else if (dataList.size() > 1) {
                file_new = String.format("%1$s_pg%2$s", file_nam, current_index);
            }
            String path = Paths.get(file_dir, new String[0]).resolve(String.format("%1$s%2$s", file_new, file_ext)).toString();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            ImageIO.write((RenderedImage)ImageIO.read(byteArrayInputStream), imageFileType, new File(path));
            paths.add(path);
        }
        return paths;
    }

    public final List<String> toJpegImages(String fileNamePattern) throws IOException {
        return this.toJpegImages(fileNamePattern, new ToImageOptions());
    }

    public final List<String> toJpegImages(String fileNamePattern, ToImageOptions options) throws IOException {
        return this.toJpegImages(fileNamePattern, options, PageSelection.allPages());
    }

    public final List<String> toJpegImages(String fileNamePattern, PageSelection pageSelection) throws IOException {
        return this.toImages(fileNamePattern, "jpg", new ToImageOptions(), pageSelection);
    }

    public final List<String> toJpegImages(String fileNamePattern, ToImageOptions options, PageSelection pageSelection) throws IOException {
        return this.toImages(fileNamePattern, "jpg", options, pageSelection);
    }

    public String toMultiPageTiff(Path filePath) throws IOException {
        return this.toMultiPageTiff(filePath, new ToImageOptions(), PageSelection.allPages());
    }

    public String toMultiPageTiff(Path filePath, PageSelection pageSelection) throws IOException {
        return this.toMultiPageTiff(filePath, new ToImageOptions(), pageSelection);
    }

    public String toMultiPageTiff(Path filePath, ToImageOptions options) throws IOException {
        return this.toMultiPageTiff(filePath, options, PageSelection.allPages());
    }

    public String toMultiPageTiff(Path filePath, ToImageOptions options, PageSelection pageSelection) throws IOException {
        byte[] tifData = Image_Api.toMultiPageTiff(this.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection), options.getDpi(), options.getImageMaxWidth(), options.getImageMaxHeight());
        return Files.write(filePath, tifData, new OpenOption[0]).toAbsolutePath().toString();
    }

    public final void compressImages(int quality) {
        this.compressImages(quality, false);
    }

    public final void compressImages(int quality, boolean scaleToVisibleSize) {
        if (quality < 1 || quality > 100) {
            throw new IndexOutOfBoundsException(String.format("Invalid quality specifier (%1$s) when compressing images. Quality must be between 1 and 100.", quality));
        }
        Compress_Api.compressImages(this.internalPdfDocument, quality, scaleToVisibleSize);
    }

    public final List<BufferedImage> extractAllImages() throws IOException {
        return this.extractAllRawImages().stream().map(bytes -> {
            BufferedImage newBi;
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])bytes);
            try {
                newBi = ImageIO.read(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return newBi;
        }).collect(Collectors.toList());
    }

    public final List<byte[]> extractAllRawImages() throws IOException {
        if (Page_Api.getPagesInfo(this.internalPdfDocument).size() == 0) {
            return new ArrayList<byte[]>();
        }
        return Image_Api.extractAllImages(this.internalPdfDocument);
    }

    public final List<BufferedImage> extractAllImagesFromPages(PageSelection pageSelection) throws IOException {
        return this.extractAllRawImagesFromPages(pageSelection).stream().map(bytes -> {
            BufferedImage newBi;
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])bytes);
            try {
                newBi = ImageIO.read(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return newBi;
        }).collect(Collectors.toList());
    }

    public final List<byte[]> extractAllRawImagesFromPages(PageSelection pageSelection) throws IOException {
        if (Page_Api.getPagesInfo(this.internalPdfDocument).size() == 0) {
            return new ArrayList<byte[]>();
        }
        return Image_Api.extractAllImages(this.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection));
    }

    public final PdfDocument saveAs(Path filePath) throws IOException {
        PdfDocument_Api.saveAs(this.internalPdfDocument, filePath.toAbsolutePath().toString());
        return this;
    }

    public final PdfDocument saveAs(String filePath) throws IOException {
        PdfDocument_Api.saveAs(this.internalPdfDocument, filePath);
        return this;
    }

    public final PdfDocument saveAsRevision(Path filePath) throws IOException {
        PdfDocument_Api.saveAsRevision(this.internalPdfDocument, filePath.toAbsolutePath().toString());
        return this;
    }

    public final PdfDocument saveAsRevision(String filePath) throws IOException {
        PdfDocument_Api.saveAsRevision(this.internalPdfDocument, filePath);
        return this;
    }

    public final byte[] getBinaryData() {
        return PdfDocument_Api.getBytes(this.internalPdfDocument, false);
    }

    public final byte[] getBinaryDataIncremental() {
        return PdfDocument_Api.getBytes(this.internalPdfDocument, true);
    }

    public final PdfDocument getRevision(int index) {
        return new PdfDocument(PdfDocument_Api.getRevision(this.internalPdfDocument, index));
    }

    public void print() throws PrinterException {
        Print_Api.print(this.internalPdfDocument, true);
    }

    public void printWithoutDialog() throws PrinterException {
        Print_Api.print(this.internalPdfDocument, false);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.internalPdfDocument.print(graphics, pageFormat, pageIndex);
    }

    public final PdfDocument applyWatermark(String html, int opacity, VerticalAlignment verticalAlignment) {
        return this.applyWatermark(html, opacity, verticalAlignment, HorizontalAlignment.CENTER);
    }

    public final PdfDocument applyWatermark(String html, int opacity, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
        HtmlStamper stamper = new HtmlStamper(html);
        stamper.setVerticalAlignment(verticalAlignment);
        stamper.setHorizontalAlignment(horizontalAlignment);
        stamper.setOpacity(opacity);
        this.applyStamp(stamper);
        return this;
    }

    public final PdfDocument applyWatermark(String html, int opacity) {
        return this.applyWatermark(html, opacity, VerticalAlignment.MIDDLE, HorizontalAlignment.CENTER);
    }

    public final PdfDocument applyWatermark(String html) {
        return this.applyWatermark(html, 50, VerticalAlignment.MIDDLE, HorizontalAlignment.CENTER);
    }

    public final PdfDocument applyStamp(Stamper stamper) {
        this.applyStamp(stamper, PageSelection.allPages());
        return this;
    }

    public final PdfDocument applyStamp(Stamper stamper, PageSelection pageSelection) {
        Stamp_Api.applyStamp(this.internalPdfDocument, stamper, this.internalPdfDocument.getPageList(pageSelection));
        return this;
    }

    public final String extractAllText() {
        return Text_Api.extractAllText(this.internalPdfDocument);
    }

    public final String extractTextFromPage(PageSelection pageSelection) {
        return Text_Api.extractAllText(this.internalPdfDocument, this.internalPdfDocument.getPageList(pageSelection));
    }

    public final void replaceText(PageSelection pageSelection, String oldText, String newText) {
        this.internalPdfDocument.getPageList(pageSelection).forEach(page -> Text_Api.replaceTextOnPage(this.internalPdfDocument, page, oldText, newText));
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath) throws IOException {
        return PdfDocument.renderHtmlFileAsPdf(htmlFilePath, null, null, null);
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath, String baseUrl) throws IOException {
        return PdfDocument.renderHtmlFileAsPdf(htmlFilePath, baseUrl, null, null);
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        return PdfDocument.renderHtmlFileAsPdf(htmlFilePath, null, renderOptions, loginCredentials);
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath, String baseUrl, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        return new PdfDocument(Render_Api.renderHtmlFileAsPdf(htmlFilePath, baseUrl, renderOptions, loginCredentials));
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        return PdfDocument.renderHtmlFileAsPdf(htmlFilePath, null, null, loginCredentials);
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath, String baseUrl, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        return PdfDocument.renderHtmlFileAsPdf(htmlFilePath, baseUrl, null, loginCredentials);
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath, ChromePdfRenderOptions renderOptions) throws IOException {
        return PdfDocument.renderHtmlFileAsPdf(htmlFilePath, renderOptions, null);
    }

    public static PdfDocument renderHtmlFileAsPdf(String htmlFilePath, String baseUrl, ChromePdfRenderOptions renderOptions) throws IOException {
        return PdfDocument.renderHtmlFileAsPdf(htmlFilePath, baseUrl, renderOptions, null);
    }

    public static PdfDocument renderUrlAsPdf(String url) {
        return PdfDocument.renderUrlAsPdf(url, null, null);
    }

    public static PdfDocument renderUrlAsPdf(String url, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) {
        return new PdfDocument(Render_Api.renderUrlAsPdf(url, renderOptions, loginCredentials));
    }

    public static PdfDocument renderUrlAsPdf(String url, ChromeHttpLoginCredentials loginCredentials) {
        return PdfDocument.renderUrlAsPdf(url, null, loginCredentials);
    }

    public static PdfDocument renderUrlAsPdf(String url, ChromePdfRenderOptions renderOptions) {
        return PdfDocument.renderUrlAsPdf(url, renderOptions, null);
    }

    public static PdfDocument renderHtmlAsPdf(String html, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials, String baseUrl) {
        return new PdfDocument(Render_Api.renderHtmlAsPdf(html, renderOptions, loginCredentials, baseUrl));
    }

    public static PdfDocument renderHtmlAsPdf(String html) {
        return PdfDocument.renderHtmlAsPdf(html, null, null, null);
    }

    public static PdfDocument renderHtmlAsPdf(String html, String baseUrl, ChromeHttpLoginCredentials loginCredentials) {
        return PdfDocument.renderHtmlAsPdf(html, null, loginCredentials, baseUrl);
    }

    public static PdfDocument renderHtmlAsPdf(String html, String baseUrl, ChromePdfRenderOptions renderOptions) {
        return PdfDocument.renderHtmlAsPdf(html, renderOptions, null, baseUrl);
    }

    public static PdfDocument renderHtmlAsPdf(String html, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) {
        return PdfDocument.renderHtmlAsPdf(html, renderOptions, loginCredentials, null);
    }

    public static PdfDocument renderHtmlAsPdf(String html, String baseUrl) {
        return PdfDocument.renderHtmlAsPdf(html, null, null, baseUrl);
    }

    public static PdfDocument renderHtmlAsPdf(String html, ChromeHttpLoginCredentials loginCredentials) {
        return PdfDocument.renderHtmlAsPdf(html, null, loginCredentials, null);
    }

    public static PdfDocument renderHtmlAsPdf(String html, ChromePdfRenderOptions renderOptions) {
        return PdfDocument.renderHtmlAsPdf(html, renderOptions, null, null);
    }

    public static PdfDocument renderRtfAsPdf(String rtfString) {
        return new PdfDocument(Render_Api.renderRtfAsPdf(rtfString));
    }

    public static PdfDocument renderRtfFileAsPdf(String rtfFilePath) throws IOException {
        return PdfDocument.renderRtfFileAsPdf(Paths.get(rtfFilePath, new String[0]));
    }

    public static PdfDocument renderRtfFileAsPdf(Path rtfFilePath) throws IOException {
        return new PdfDocument(Render_Api.renderRtfAsPdf(String.join((CharSequence)"", Files.readAllLines(rtfFilePath))));
    }

    public static PdfDocument renderZipAsPdf(Path zipFilePath, String mainFile, ChromePdfRenderOptions renderOptions) throws IOException {
        return new PdfDocument(Render_Api.renderZipAsPdf(zipFilePath, mainFile, renderOptions, new ChromeHttpLoginCredentials()));
    }

    public static PdfDocument renderZipAsPdf(Path zipFilePath, String mainFile) throws IOException {
        return new PdfDocument(Render_Api.renderZipAsPdf(zipFilePath, mainFile, new ChromePdfRenderOptions(), new ChromeHttpLoginCredentials()));
    }
}

