/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitreport;

import android.content.Context;
import android.support.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadReporter;
import java.util.List;

public class DefaultSplitLoadReporter
implements SplitLoadReporter {
    private static final String TAG = "SplitLoadReporter";
    protected final Context context;

    public DefaultSplitLoadReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onLoadOK(String processName, @NonNull List<SplitBriefInfo> loadedSplits, long cost) {
        SplitLog.i((String)TAG, (String)"Success to load %s in process %s cost %d ms!", (Object[])new Object[]{loadedSplits, processName, cost});
    }

    @Override
    public void onLoadFailed(String processName, @NonNull List<SplitBriefInfo> loadedSplits, @NonNull List<SplitLoadError> errors, long cost) {
        for (SplitLoadError loadError : errors) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)loadError.cause, (String)"Failed to load split %s in process %s cost %d ms, error code: %d!", (Object[])new Object[]{loadError.splitName, loadError.toString(), processName, cost, loadError.errorCode});
        }
    }
}

