/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitreport;

import android.content.Context;
import android.support.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallReporter;
import java.util.List;

public class DefaultSplitInstallReporter
implements SplitInstallReporter {
    private static final String TAG = "SplitInstallReporter";
    protected final Context context;

    public DefaultSplitInstallReporter(Context context) {
        this.context = context;
    }

    @Override
    public void onStartInstallOK(List<SplitBriefInfo> requestSplits, long cost) {
        SplitLog.i((String)TAG, (String)"Start install %s OK, cost time %d ms.", (Object[])new Object[]{requestSplits.toString(), cost});
    }

    @Override
    public void onStartInstallFailed(List<SplitBriefInfo> requestSplits, @NonNull SplitInstallError error, long cost) {
        SplitLog.printErrStackTrace((String)TAG, (Throwable)error.cause, (String)"Start install splits %s but %s installed failed, cost time %d ms.", (Object[])new Object[]{requestSplits.toString(), error.splitName, cost});
    }

    @Override
    public void onDeferredInstallOK(List<SplitBriefInfo> requestSplits, long cost) {
        SplitLog.i((String)TAG, (String)"Deferred install %s OK, cost time %d ms.", (Object[])new Object[]{requestSplits.toString(), cost});
    }

    @Override
    public void onDeferredInstallFailed(List<SplitBriefInfo> requestSplits, @NonNull List<SplitInstallError> errors, long cost) {
        for (SplitInstallError installError : errors) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)installError.cause, (String)"Deferred install splits %s but %s installed failed with error code %d, cost time %d ms.", (Object[])new Object[]{requestSplits.toString(), installError.splitName, installError.errorCode, cost});
        }
    }
}

