/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import androidx.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.splitload.SplitDexClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

final class SplitApplicationLoaders {
    private final Set<SplitDexClassLoader> splitDexClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final AtomicReference<SplitApplicationLoaders> sInstance = new AtomicReference();

    SplitApplicationLoaders() {
    }

    public static SplitApplicationLoaders getInstance() {
        if (sInstance.get() == null) {
            sInstance.set(new SplitApplicationLoaders());
        }
        return sInstance.get();
    }

    void addClassLoader(SplitDexClassLoader classLoader) {
        this.splitDexClassLoaders.add(classLoader);
    }

    Set<SplitDexClassLoader> getValidClassLoaders() {
        HashSet<SplitDexClassLoader> validClassLoaders = new HashSet<SplitDexClassLoader>(this.splitDexClassLoaders.size());
        for (SplitDexClassLoader classLoader : this.splitDexClassLoaders) {
            if (!classLoader.isValid()) continue;
            validClassLoaders.add(classLoader);
        }
        return validClassLoaders;
    }

    @Nullable
    Set<SplitDexClassLoader> getValidClassLoaders(@Nullable List<String> moduleNames) {
        if (moduleNames == null) {
            return null;
        }
        HashSet<SplitDexClassLoader> loaders = new HashSet<SplitDexClassLoader>(moduleNames.size());
        for (SplitDexClassLoader classLoader : this.splitDexClassLoaders) {
            if (!moduleNames.contains(classLoader.moduleName()) || !classLoader.isValid()) continue;
            loaders.add(classLoader);
        }
        return loaders;
    }

    @Nullable
    SplitDexClassLoader getValidClassLoader(String moduleName) {
        for (SplitDexClassLoader classLoader : this.splitDexClassLoaders) {
            if (!classLoader.moduleName().equals(moduleName) || !classLoader.isValid()) continue;
            return classLoader;
        }
        return null;
    }

    @Nullable
    SplitDexClassLoader getClassLoader(String moduleName) {
        for (SplitDexClassLoader classLoader : this.splitDexClassLoaders) {
            if (!classLoader.moduleName().equals(moduleName)) continue;
            return classLoader;
        }
        return null;
    }
}

