/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.OEMCompat;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.DefaultClassNotFoundInterceptor;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatResourcesLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitDelegateClassloader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadTaskImpl;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadTaskImpl2;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class SplitLoadManagerImpl
extends SplitLoadManager {
    private final boolean qigsawMode;
    private final String[] forbiddenWorkProcesses;
    private final String[] workProcesses;

    SplitLoadManagerImpl(Context context, int splitLoadMode, boolean qigsawMode, boolean isMainProcess, String currentProcessName, String[] workProcesses, String[] forbiddenWorkProcesses) {
        super(context, currentProcessName, splitLoadMode);
        this.qigsawMode = qigsawMode;
        this.workProcesses = workProcesses;
        this.forbiddenWorkProcesses = forbiddenWorkProcesses;
        SplitInfoManagerService.install((Context)context, (boolean)isMainProcess);
        SplitPathManager.install((Context)context);
    }

    @Override
    public void injectPathClassloader() {
        ClassLoader curCl;
        if (this.isInjectPathClassloaderNeeded() && this.isProcessAllowedToWork()) {
            this.injectClassLoader(this.getContext().getClassLoader());
        }
        if ((curCl = this.getContext().getClassLoader()) instanceof SplitDelegateClassloader) {
            DefaultClassNotFoundInterceptor classNotFoundInterceptor = new DefaultClassNotFoundInterceptor(this.getContext(), this.getClass().getClassLoader(), this.splitLoadMode());
            ((SplitDelegateClassloader)((Object)curCl)).setClassNotFoundInterceptor(classNotFoundInterceptor);
        }
    }

    @Override
    public void preloadInstalledSplits(Collection<String> splitNames) {
        if (!this.qigsawMode) {
            return;
        }
        if (this.isProcessAllowedToWork()) {
            this.loadInstalledSplitsInternal(splitNames);
        }
    }

    @Override
    public void getResources(Resources resources) {
        try {
            SplitCompatResourcesLoader.loadResources(this.getContext(), resources);
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
    }

    @Override
    public Runnable createSplitLoadTask(List<Intent> splitFileIntents, @Nullable OnSplitLoadListener loadListener) {
        if (this.splitLoadMode() == 1) {
            return new SplitLoadTaskImpl(this, splitFileIntents, loadListener);
        }
        return new SplitLoadTaskImpl2(this, splitFileIntents, loadListener);
    }

    @Override
    public void loadInstalledSplits() {
        this.loadInstalledSplitsInternal(null);
    }

    private void loadInstalledSplitsInternal(Collection<String> splitNames) {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        if (manager == null) {
            SplitLog.w((String)"SplitLoadManager", (String)"Failed to get SplitInfoManager instance, have you invoke Qigsaw#install(...) method?", (Object[])new Object[0]);
            return;
        }
        Collection splitInfoList = splitNames == null ? manager.getAllSplitInfo(this.getContext()) : manager.getSplitInfos(this.getContext(), splitNames);
        if (splitInfoList == null || splitInfoList.isEmpty()) {
            SplitLog.w((String)"SplitLoadManager", (String)"Failed to get Split-Info list!", (Object[])new Object[0]);
            return;
        }
        List<Intent> splitFileIntents = this.createInstalledSplitFileIntents(splitInfoList);
        if (splitFileIntents.isEmpty()) {
            SplitLog.w((String)"SplitLoadManager", (String)"There are no installed splits!", (Object[])new Object[0]);
            return;
        }
        this.createSplitLoadTask(splitFileIntents, null).run();
    }

    private boolean isInjectPathClassloaderNeeded() {
        if (Build.VERSION.SDK_INT < 29) {
            return this.qigsawMode;
        }
        boolean exist = this.getContext().getClassLoader() instanceof SplitDelegateClassloader;
        return !exist && this.qigsawMode;
    }

    private List<Intent> createInstalledSplitFileIntents(@NonNull Collection<SplitInfo> splitInfoList) {
        ArrayList<Intent> splitFileIntents = new ArrayList<Intent>();
        for (SplitInfo splitInfo : splitInfoList) {
            if (this.canBeWorkedInThisProcessForSplit(splitInfo)) {
                if (this.getLoadedSplitNames().contains(splitInfo.getSplitName())) {
                    SplitLog.i((String)"SplitLoadManager", (String)"Split %s has been loaded, ignore it!", (Object[])new Object[]{splitInfo.getSplitName()});
                    continue;
                }
                try {
                    boolean libBuiltIn;
                    Intent splitFileIntent;
                    SplitInfo.ApkData masterApkData = splitInfo.getApkDataForMaster();
                    SplitInfo.LibData libData = splitInfo.getPrimaryLibData(this.getContext());
                    String installedMark = splitInfo.obtainInstalledMark(this.getContext());
                    File splitLibDir = null;
                    if (libData != null) {
                        splitLibDir = SplitPathManager.require().getSplitLibDir(splitInfo, libData.getAbi());
                    }
                    if ((splitFileIntent = this.createLastInstalledSplitFileIntent(libBuiltIn = splitInfo.isBuiltIn() && masterApkData.getUrl().startsWith("native://"), installedMark, splitLibDir, splitInfo)) != null) {
                        splitFileIntents.add(splitFileIntent);
                    }
                    SplitLog.i((String)"SplitLoadManager", (String)"Split %s will work in process %s, %s it is %s", (Object[])new Object[]{splitInfo.getSplitName(), this.currentProcessName, splitFileIntent == null ? "but" : "and", splitFileIntent == null ? "not installed" : "installed"});
                }
                catch (IOException iOException) {}
                continue;
            }
            SplitLog.i((String)"SplitLoadManager", (String)"Split %s do not need work in process %s", (Object[])new Object[]{splitInfo.getSplitName(), this.currentProcessName});
        }
        return splitFileIntents;
    }

    private boolean canBeWorkedInThisProcessForSplit(SplitInfo splitInfo) {
        List workProcesses = splitInfo.getWorkProcesses();
        if (workProcesses != null && !workProcesses.isEmpty()) {
            String packageName = this.getContext().getPackageName();
            String simpleProcessName = this.currentProcessName.replace(packageName, "");
            return workProcesses.contains(simpleProcessName);
        }
        return true;
    }

    private Intent createLastInstalledSplitFileIntent(boolean libBuiltIn, String mark, File splitLibDir, SplitInfo splitInfo) {
        String splitName = splitInfo.getSplitName();
        File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
        File markFile = SplitPathManager.require().getSplitMarkFile(splitInfo, mark);
        File specialMarkFile = SplitPathManager.require().getSplitSpecialMarkFile(splitInfo, mark);
        File splitApk = libBuiltIn ? new File(this.getContext().getApplicationInfo().nativeLibraryDir, System.mapLibraryName("split_" + splitInfo.getSplitName())) : new File(splitDir, splitName + "-" + "master" + ".apk");
        if (specialMarkFile.exists() && !markFile.exists()) {
            SplitLog.v((String)"SplitLoadManager", (String)"In vivo & oppo, we need to check oat file when split is going to be loaded.", (Object[])new Object[0]);
            File optimizedDirectory = SplitPathManager.require().getSplitOptDir(splitInfo);
            File oatFile = OEMCompat.getOatFilePath((File)splitApk, (File)optimizedDirectory);
            if (FileUtil.isLegalFile((File)oatFile)) {
                boolean result = OEMCompat.checkOatFile((File)oatFile);
                SplitLog.v((String)"SplitLoadManager", (String)("Check result of oat file %s is " + result), (Object[])new Object[]{oatFile.getAbsoluteFile()});
                File lockFile = SplitPathManager.require().getSplitSpecialLockFile(splitInfo);
                if (result) {
                    try {
                        FileUtil.createFileSafelyLock((File)markFile, (File)lockFile);
                    }
                    catch (IOException e) {
                        SplitLog.w((String)"SplitLoadManager", (String)("Failed to create installed mark file " + oatFile.exists()), (Object[])new Object[0]);
                    }
                } else {
                    try {
                        FileUtil.deleteFileSafelyLock((File)oatFile, (File)lockFile);
                    }
                    catch (IOException e) {
                        SplitLog.w((String)"SplitLoadManager", (String)("Failed to delete corrupted oat file " + oatFile.exists()), (Object[])new Object[0]);
                    }
                }
            } else {
                SplitLog.v((String)"SplitLoadManager", (String)"Oat file %s is still not exist in vivo & oppo, system continue to use interpreter mode.", (Object[])new Object[]{oatFile.getAbsoluteFile()});
            }
        }
        if (markFile.exists() || specialMarkFile.exists()) {
            List dependencies = splitInfo.getDependencies();
            if (dependencies != null) {
                SplitLog.i((String)"SplitLoadManager", (String)"Split %s has dependencies %s !", (Object[])new Object[]{splitName, dependencies});
                for (String dependency : dependencies) {
                    SplitInfo dependSplitInfo = SplitInfoManagerService.getInstance().getSplitInfo(this.getContext(), dependency);
                    try {
                        String dependInstalledMark = dependSplitInfo.obtainInstalledMark(this.getContext());
                        File dependMarkFile = SplitPathManager.require().getSplitMarkFile(dependSplitInfo, dependInstalledMark);
                        if (dependMarkFile.exists()) continue;
                        SplitLog.i((String)"SplitLoadManager", (String)"Dependency %s mark file is not existed!", (Object[])new Object[]{dependency});
                        return null;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            }
            File optimizedDirectory = null;
            ArrayList<String> addedDexPaths = null;
            if (splitInfo.hasDex()) {
                optimizedDirectory = SplitPathManager.require().getSplitOptDir(splitInfo);
                addedDexPaths = new ArrayList<String>();
                addedDexPaths.add(splitApk.getAbsolutePath());
                File[] results = SplitPathManager.require().getSplitCodeCacheDir(splitInfo).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".zip");
                    }
                });
                if (results != null && results.length > 0) {
                    for (File result : results) {
                        addedDexPaths.add(result.getAbsolutePath());
                    }
                }
            }
            Intent splitFileIntent = new Intent();
            splitFileIntent.putExtra("splitName", splitName);
            splitFileIntent.putExtra("apk", splitApk.getAbsolutePath());
            if (optimizedDirectory != null) {
                splitFileIntent.putExtra("dex-opt-dir", optimizedDirectory.getAbsolutePath());
            }
            if (splitLibDir != null) {
                splitFileIntent.putExtra("native-lib-dir", splitLibDir.getAbsolutePath());
            }
            if (addedDexPaths != null) {
                splitFileIntent.putStringArrayListExtra("added-dex", addedDexPaths);
            }
            return splitFileIntent;
        }
        return null;
    }

    private void injectClassLoader(ClassLoader originalClassloader) {
        try {
            SplitDelegateClassloader.inject(originalClassloader, this.getBaseContext());
        }
        catch (Exception e) {
            SplitLog.printErrStackTrace((String)"SplitLoadManager", (Throwable)e, (String)"Failed to hook PathClassloader", (Object[])new Object[0]);
        }
    }

    private Context getBaseContext() {
        Context ctx = this.getContext();
        while (ctx instanceof ContextWrapper) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx;
    }

    private boolean isProcessAllowedToWork() {
        if (this.workProcesses == null && this.forbiddenWorkProcesses == null) {
            return true;
        }
        if (this.getContext().getPackageName().equals(this.currentProcessName)) {
            return true;
        }
        if (this.forbiddenWorkProcesses != null) {
            for (String process : this.forbiddenWorkProcesses) {
                if (!this.getCompleteProcessName(process).equals(this.currentProcessName)) continue;
                return false;
            }
        }
        if (this.workProcesses != null) {
            for (String process : this.workProcesses) {
                if (!this.getCompleteProcessName(process).equals(this.currentProcessName)) continue;
                return true;
            }
        }
        return true;
    }

    private String getCompleteProcessName(String process) {
        String packageName = this.getContext().getPackageName();
        if (TextUtils.isEmpty((CharSequence)process)) {
            return packageName;
        }
        if (process.startsWith(packageName)) {
            return process;
        }
        return packageName + process;
    }
}

