/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.SplitActivator;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoaderWrapper;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadError;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

final class SplitLoadHandler {
    private static final String TAG = "SplitLoadHandler";
    private final Handler mainHandler;
    private final SplitLoadManager loadManager;
    private final SplitLoaderWrapper splitLoader;
    private final SplitInfoManager infoManager;
    private final List<Intent> splitFileIntents;
    private final SplitActivator activator;

    SplitLoadHandler(@NonNull SplitLoaderWrapper splitLoader, @NonNull SplitLoadManager loadManager, @NonNull List<Intent> splitFileIntents) {
        this.splitLoader = splitLoader;
        this.loadManager = loadManager;
        this.splitFileIntents = splitFileIntents;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.infoManager = SplitInfoManagerService.getInstance();
        this.activator = new SplitActivator(loadManager.getContext());
    }

    Handler getMainHandler() {
        return this.mainHandler;
    }

    @MainThread
    final void loadSplitsSync(OnSplitLoadFinishListener loadFinishListener) {
        this.loadSplits(loadFinishListener);
    }

    private void loadSplits(OnSplitLoadFinishListener loadFinishListener) {
        long totalLoadStart = System.currentTimeMillis();
        HashSet<Split> loadedSpits = new HashSet<Split>();
        ArrayList<SplitLoadError> loadErrorInfos = new ArrayList<SplitLoadError>(0);
        ArrayList<SplitBriefInfo> loadOKInfos = new ArrayList<SplitBriefInfo>(this.splitFileIntents.size());
        for (Intent splitFileIntent : this.splitFileIntents) {
            Application application;
            ClassLoader classLoader;
            String nativeLibPath;
            String dexOptPath;
            String splitApkPath;
            SplitBriefInfo splitBriefInfo;
            SplitInfo info;
            String splitName;
            long loadStart;
            block16: {
                loadStart = System.currentTimeMillis();
                splitName = splitFileIntent.getStringExtra("splitName");
                info = this.infoManager.getSplitInfo(this.getContext(), splitName);
                if (info == null) {
                    SplitLog.w((String)TAG, (String)"Unable to get info for %s, just skip!", (Object[])new Object[]{splitName == null ? "null" : splitName});
                    continue;
                }
                splitBriefInfo = new SplitBriefInfo(info.getSplitName(), info.getSplitVersion(), info.isBuiltIn());
                if (this.checkSplitLoaded(splitName)) {
                    SplitLog.i((String)TAG, (String)"Split %s has been loaded!", (Object[])new Object[]{splitName});
                    continue;
                }
                splitApkPath = splitFileIntent.getStringExtra("apk");
                if (splitApkPath == null) {
                    SplitLog.w((String)TAG, (String)"Failed to read split %s apk path", (Object[])new Object[]{splitName});
                    loadErrorInfos.add(new SplitLoadError(splitBriefInfo, -100, (Throwable)new Exception("split apk path " + splitName + " is missing!")));
                    continue;
                }
                dexOptPath = splitFileIntent.getStringExtra("dex-opt-dir");
                if (info.hasDex() && dexOptPath == null) {
                    SplitLog.w((String)TAG, (String)"Failed to %s get dex-opt-dir", (Object[])new Object[]{splitName});
                    loadErrorInfos.add(new SplitLoadError(splitBriefInfo, -100, (Throwable)new Exception("dex-opt-dir of " + splitName + " is missing!")));
                    continue;
                }
                nativeLibPath = splitFileIntent.getStringExtra("native-lib-dir");
                try {
                    SplitInfo.LibData libData = info.getPrimaryLibData(this.getContext());
                    if (libData != null && nativeLibPath == null) {
                        SplitLog.w((String)TAG, (String)"Failed to get %s native-lib-dir", (Object[])new Object[]{splitName});
                        loadErrorInfos.add(new SplitLoadError(splitBriefInfo, -100, (Throwable)new Exception("native-lib-dir of " + splitName + " is missing!")));
                    }
                    break block16;
                }
                catch (IOException e) {
                    loadErrorInfos.add(new SplitLoadError(splitBriefInfo, -100, (Throwable)e));
                }
                continue;
            }
            ArrayList addedDexPaths = splitFileIntent.getStringArrayListExtra("added-dex");
            try {
                classLoader = this.splitLoader.loadCode(splitName, addedDexPaths, dexOptPath == null ? null : new File(dexOptPath), nativeLibPath == null ? null : new File(nativeLibPath), info.getDependencies());
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to load split %s code!", (Object[])new Object[]{splitName});
                loadErrorInfos.add(new SplitLoadError(splitBriefInfo, e.getErrorCode(), e.getCause()));
                continue;
            }
            try {
                application = this.activator.createSplitApplication(classLoader, splitName);
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to create %s application ", (Object[])new Object[]{splitName});
                loadErrorInfos.add(new SplitLoadError(splitBriefInfo, e.getErrorCode(), e.getCause()));
                this.splitLoader.unloadCode(classLoader);
                continue;
            }
            try {
                this.activateSplit(splitName, splitApkPath, application, classLoader);
            }
            catch (SplitLoadException e) {
                loadErrorInfos.add(new SplitLoadError(splitBriefInfo, e.getErrorCode(), e.getCause()));
                this.splitLoader.unloadCode(classLoader);
                continue;
            }
            File splitDir = SplitPathManager.require().getSplitDir(info);
            if (!splitDir.setLastModified(System.currentTimeMillis())) {
                SplitLog.w((String)TAG, (String)("Failed to set last modified time for " + splitName), (Object[])new Object[0]);
            }
            loadOKInfos.add(splitBriefInfo.setTimeCost(System.currentTimeMillis() - loadStart));
            loadedSpits.add(new Split(splitName, splitApkPath));
        }
        this.loadManager.putSplits(loadedSpits);
        if (loadFinishListener != null) {
            loadFinishListener.onLoadFinish(loadOKInfos, loadErrorInfos, this.loadManager.currentProcessName, System.currentTimeMillis() - totalLoadStart);
        }
    }

    private void activateSplit(String splitName, String splitApkPath, Application application, ClassLoader classLoader) throws SplitLoadException {
        try {
            this.splitLoader.loadResources(splitApkPath);
        }
        catch (SplitLoadException e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to load %s resources", (Object[])new Object[]{splitApkPath});
        }
        try {
            this.activator.attachSplitApplication(application);
        }
        catch (SplitLoadException e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to attach %s application", (Object[])new Object[]{splitName});
            throw e;
        }
        try {
            this.activator.createAndActivateSplitContentProviders(classLoader, splitName);
        }
        catch (SplitLoadException e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to create %s content-provider ", (Object[])new Object[]{splitName});
            throw e;
        }
        try {
            this.activator.invokeOnCreateForSplitApplication(application);
        }
        catch (SplitLoadException e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to invoke onCreate for %s application", (Object[])new Object[]{splitName});
            throw e;
        }
    }

    private boolean checkSplitLoaded(String splitName) {
        for (Split split : this.loadManager.getLoadedSplits()) {
            if (!split.splitName.equals(splitName)) continue;
            return true;
        }
        return false;
    }

    final Context getContext() {
        return this.loadManager.getContext();
    }

    static interface OnSplitLoadFinishListener {
        public void onLoadFinish(List<SplitBriefInfo> var1, List<SplitLoadError> var2, String var3, long var4);
    }
}

