/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerImpl;
import java.util.concurrent.atomic.AtomicReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitLoadManagerService {
    private static final AtomicReference<SplitLoadManager> sReference = new AtomicReference();

    public static void install(Context context, int splitLoadMode, boolean qigsawMode, boolean isMainProcess, String currentProcessName, String[] workProcesses, String[] forbiddenWorkProcesses) {
        if (sReference.get() == null) {
            sReference.set(SplitLoadManagerService.create(context, splitLoadMode, qigsawMode, isMainProcess, currentProcessName, workProcesses, forbiddenWorkProcesses));
        }
    }

    public static boolean hasInstance() {
        return sReference.get() != null;
    }

    public static SplitLoadManager getInstance() {
        if (sReference.get() == null) {
            throw new RuntimeException("Have you invoke SplitLoadManagerService#install(Context) method?");
        }
        return sReference.get();
    }

    private static SplitLoadManager create(Context context, int splitLoadMode, boolean qigsawMode, boolean isMainProcess, String currentProcessName, String[] workProcesses, String[] forbiddenWorkProcesses) {
        return new SplitLoadManagerImpl(context, splitLoadMode, qigsawMode, isMainProcess, currentProcessName, workProcesses, forbiddenWorkProcesses);
    }
}

