/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.SplitDelegateClassloader;
import com.iqiyi.android.qigsaw.core.splitload.SplitUnKnownFileTypeDexLoader;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.util.List;

final class SplitDexClassLoader
extends BaseDexClassLoader {
    private static final String TAG = "SplitDexClassLoader";
    private final String moduleName;

    private SplitDexClassLoader(String moduleName, List<String> dexPaths, File optimizedDirectory, String librarySearchPath, ClassLoader parent) throws Throwable {
        super(dexPaths == null ? "" : TextUtils.join((CharSequence)File.pathSeparator, dexPaths), optimizedDirectory, librarySearchPath, parent);
        this.moduleName = moduleName;
        SplitUnKnownFileTypeDexLoader.loadDex((ClassLoader)((Object)this), dexPaths, optimizedDirectory);
    }

    static SplitDexClassLoader create(String moduleName, List<String> dexPaths, File optimizedDirectory, File librarySearchFile) throws Throwable {
        long time = System.currentTimeMillis();
        SplitDexClassLoader cl = new SplitDexClassLoader(moduleName, dexPaths, optimizedDirectory, librarySearchFile == null ? null : librarySearchFile.getAbsolutePath(), SplitDexClassLoader.class.getClassLoader());
        SplitLog.d((String)TAG, (String)"Cost %d ms to load %s code", (Object[])new Object[]{System.currentTimeMillis() - time, moduleName});
        return cl;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException error) {
            if (SplitDelegateClassloader.sInstance != null) {
                return SplitDelegateClassloader.sInstance.findClassInSplits(name, this);
            }
            throw error;
        }
    }

    String moduleName() {
        return this.moduleName;
    }

    Class<?> loadClassItself(String name) throws ClassNotFoundException {
        Class cl = this.findLoadedClass(name);
        if (cl != null) {
            return cl;
        }
        return super.findClass(name);
    }
}

