/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import com.iqiyi.android.qigsaw.core.splitload.fakecomponents.FakeActivity;
import com.iqiyi.android.qigsaw.core.splitload.fakecomponents.FakeReceiver;
import com.iqiyi.android.qigsaw.core.splitload.fakecomponents.FakeService;
import dalvik.system.PathClassLoader;

final class SplitProxyClassloader
extends PathClassLoader {
    private static final String TAG = "SplitDexClassloader";
    private PathClassLoader originClassLoader;
    private String lastClassNotFound = null;

    private SplitProxyClassloader(String dexPath, ClassLoader parent) {
        super(dexPath, parent);
        this.originClassLoader = (PathClassLoader)parent;
    }

    private static void reflectPackageInfoClassloader(Context appContext, ClassLoader reflectClassLoader) throws Exception {
        Context baseContext = (Context)HiddenApiReflection.findField(appContext, "mBase").get(appContext);
        Object basePackageInfo = HiddenApiReflection.findField(baseContext, "mPackageInfo").get(baseContext);
        HiddenApiReflection.findField(basePackageInfo, "mClassLoader").set(basePackageInfo, reflectClassLoader);
        Thread.currentThread().setContextClassLoader(reflectClassLoader);
    }

    static PathClassLoader inject(ClassLoader originalClassloader, Context appContext) throws Exception {
        SplitProxyClassloader classLoader = new SplitProxyClassloader("", originalClassloader);
        SplitProxyClassloader.reflectPackageInfoClassloader(appContext, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.originClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException error) {
            if (this.lastClassNotFound == null) {
                if (AABExtension.getInstance().isSplitComponents(name)) {
                    if (SplitLoadManagerService.hasInstance()) {
                        this.lastClassNotFound = name;
                        SplitLog.w((String)TAG, (String)"class %s is not found", (Object[])new Object[]{name});
                        SplitLoadManager loadManager = SplitLoadManagerService.getInstance();
                        loadManager.loadInstalledSplits(true);
                        return this.findClass(name);
                    }
                    SplitLog.e((String)TAG, (String)"SplitLoadManagerService has not been created!", (Object[])new Object[]{name});
                }
            } else {
                SplitLog.w((String)TAG, (String)"class %s is still not found!", (Object[])new Object[]{name});
                if (AABExtension.getInstance().isSplitActivities(name)) {
                    SplitLog.w((String)TAG, (String)"Split activity %s not found, return a fake activity to avoid crash", (Object[])new Object[]{name});
                    return FakeActivity.class;
                }
                if (AABExtension.getInstance().isSplitServices(name)) {
                    SplitLog.w((String)TAG, (String)"Split service %s not found, return a fake service to avoid crash", (Object[])new Object[]{name});
                    return FakeService.class;
                }
                if (AABExtension.getInstance().isSplitReceivers(name)) {
                    SplitLog.w((String)TAG, (String)"Split receiver %s not found, return a fake receiver to avoid crash", (Object[])new Object[]{name});
                    return FakeReceiver.class;
                }
                this.lastClassNotFound = null;
            }
            throw error;
        }
    }

    public String findLibrary(String name) {
        String mapLib = this.originClassLoader.findLibrary(name);
        if (mapLib == null || mapLib.length() == 0) {
            return super.findLibrary(name);
        }
        return mapLib;
    }
}

