/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Looper;
import android.os.MessageQueue;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.ProcessUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatResourcesLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadTask;
import com.iqiyi.android.qigsaw.core.splitload.SplitProxyClassloader;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class SplitLoadManagerImpl
extends SplitLoadManager {
    private static final String TAG = "SplitLoadManagerImpl";
    private PathClassLoader mClassloader;

    SplitLoadManagerImpl(Context context) {
        super(context);
        SplitInfoManagerService.install((Context)context);
        SplitPathManager.install((Context)context);
    }

    @Override
    public void load(String[] processes, boolean needHookClassLoader) {
        if (processes == null || processes.length == 0) {
            this.loadInternal(needHookClassLoader);
        } else {
            for (String process : processes) {
                if (!this.getCompleteProcessName(process).equals(this.getCurrentProcessName())) continue;
                this.loadInternal(needHookClassLoader);
            }
        }
    }

    @Override
    public void getResources(Resources resources) {
        Set<Split> loadedSplits = this.getLoadedSplits();
        if (!loadedSplits.isEmpty()) {
            for (Split split : loadedSplits) {
                try {
                    SplitCompatResourcesLoader.loadResources(this.getContext(), resources, split.splitApkPath);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    @Override
    public Runnable createSplitLoadTask(List<Intent> splitFileIntents, @Nullable OnSplitLoadListener loadListener, boolean processStarting) {
        return new SplitLoadTask(this, splitFileIntents, loadListener, processStarting);
    }

    private List<Intent> createInstalledSplitFileIntents(@NonNull Collection<SplitInfo> splitInfoList) {
        ArrayList<Intent> splitFileIntents = new ArrayList<Intent>();
        for (SplitInfo splitInfo : splitInfoList) {
            if (this.canBeWorkedInThisProcessForSplit(splitInfo)) {
                if (this.getLoadedSplitNames().contains(splitInfo.getSplitName())) {
                    SplitLog.i((String)TAG, (String)"Split %s has been load!'createInstalledSplitFileIntents'", (Object[])new Object[]{splitInfo.getSplitName()});
                    continue;
                }
                SplitLog.i((String)TAG, (String)"Split %s will work in this process", (Object[])new Object[]{splitInfo.getSplitName()});
                Intent splitFileIntent = this.createLastInstalledSplitFileIntent(splitInfo);
                if (splitFileIntent == null) continue;
                SplitLog.i((String)TAG, (String)("installed split name " + splitInfo.getSplitName()), (Object[])new Object[0]);
                splitFileIntents.add(splitFileIntent);
                continue;
            }
            SplitLog.i((String)TAG, (String)"Split %s do not need work in this process", (Object[])new Object[]{splitInfo.getSplitName()});
        }
        return splitFileIntents;
    }

    private boolean canBeWorkedInThisProcessForSplit(SplitInfo splitInfo) {
        List workProcesses = splitInfo.getWorkProcesses();
        if (workProcesses != null && !workProcesses.isEmpty()) {
            String currentProcessName = ProcessUtil.getProcessName((Context)this.getContext());
            String packageName = this.getContext().getPackageName();
            String simpleProcessName = currentProcessName.replace(packageName, "");
            SplitLog.i((String)TAG, (String)("Current process simple name: " + (TextUtils.isEmpty((CharSequence)simpleProcessName) ? "null" : simpleProcessName)), (Object[])new Object[0]);
            return workProcesses.contains(simpleProcessName);
        }
        return true;
    }

    @Override
    PathClassLoader getInjectedClassloader() {
        return (PathClassLoader)(this.mClassloader == null ? this.getContext().getClassLoader() : this.mClassloader.getParent());
    }

    @Override
    public void loadInstalledSplits(boolean processStarting) {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        if (manager != null) {
            Collection splitInfoList = manager.getAllSplitInfo(this.getContext());
            if (splitInfoList != null) {
                List<Intent> splitFileIntents = this.createInstalledSplitFileIntents(splitInfoList);
                if (!splitFileIntents.isEmpty()) {
                    this.createSplitLoadTask(splitFileIntents, null, processStarting).run();
                } else {
                    SplitLog.w((String)TAG, (String)"There are no installed splits!", (Object[])new Object[0]);
                }
            } else {
                SplitLog.w((String)TAG, (String)"Failed to get Split-Info list!", (Object[])new Object[0]);
            }
        } else {
            SplitLog.w((String)TAG, (String)"Failed to get SplitInfoManager instance!", (Object[])new Object[0]);
        }
    }

    private void loadInternal(boolean needHookClassLoader) {
        if (needHookClassLoader) {
            SplitLog.i((String)TAG, (String)"AppComponentFactory is not declared in app Manifest, so we need hook PathClassLoader!", (Object[])new Object[0]);
            this.injectClassLoader(this.getContext().getClassLoader());
        } else {
            SplitLog.i((String)TAG, (String)"AppComponentFactory is  declared in app Manifest!", (Object[])new Object[0]);
        }
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                SplitLoadManagerImpl.this.loadInstalledSplits(true);
                return false;
            }
        });
    }

    private String getCompleteProcessName(@Nullable String process) {
        String packageName = this.getContext().getPackageName();
        if (TextUtils.isEmpty((CharSequence)process)) {
            return packageName;
        }
        if (process.startsWith(packageName)) {
            return process;
        }
        return packageName + process;
    }

    private Intent createLastInstalledSplitFileIntent(SplitInfo splitInfo) {
        String splitName = splitInfo.getSplitName();
        File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
        File markFile = new File(splitDir, splitInfo.getMd5());
        File splitApk = new File(splitDir, splitName + ".apk");
        if (markFile.exists()) {
            SplitLog.i((String)TAG, (String)"Split %s mark file is existed!", (Object[])new Object[]{splitName});
            File libDir = null;
            if (splitInfo.hasLibs()) {
                libDir = SplitPathManager.require().getSplitLibDir(splitInfo);
            }
            ArrayList<String> multiDexFiles = null;
            File optDir = null;
            if (splitInfo.hasDex()) {
                optDir = SplitPathManager.require().getSplitOptDir(splitInfo);
                File[] results = SplitPathManager.require().getSplitCodeCacheDir(splitInfo).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".zip");
                    }
                });
                if (results != null && results.length > 0) {
                    multiDexFiles = new ArrayList<String>(results.length);
                    for (File result : results) {
                        multiDexFiles.add(result.getAbsolutePath());
                    }
                }
            }
            Intent splitFileIntent = new Intent();
            splitFileIntent.putExtra("splitName", splitName);
            splitFileIntent.putExtra("apk", splitApk.getAbsolutePath());
            splitFileIntent.putExtra("splitDir", splitDir.getAbsolutePath());
            if (optDir != null) {
                splitFileIntent.putExtra("optimized-directory", optDir.getAbsolutePath());
            }
            if (libDir != null) {
                splitFileIntent.putExtra("native-libraries", libDir.getAbsolutePath());
            }
            if (multiDexFiles != null) {
                splitFileIntent.putStringArrayListExtra("multi-dex", multiDexFiles);
            }
            SplitLog.i((String)"SplitCompat", (String)"Split %s has been installed, so we can load it", (Object[])new Object[]{splitName});
            return splitFileIntent;
        }
        SplitLog.i((String)TAG, (String)"Split %s mark file is not existed!", (Object[])new Object[]{splitName});
        SplitLog.i((String)TAG, (String)("Split %s apk file is existed? " + splitApk.exists()), (Object[])new Object[]{splitName});
        return null;
    }

    private void injectClassLoader(ClassLoader originalClassloader) {
        try {
            this.mClassloader = SplitProxyClassloader.inject(originalClassloader, this.getContext());
        }
        catch (Exception e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to hook PathClassloader", (Object[])new Object[0]);
        }
    }
}

