/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import com.iqiyi.android.qigsaw.core.splitdownload.DownloadCallback;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallInternalSessionState;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallSessionManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallerExecutor;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitSessionInstaller;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitSessionInstallerImpl;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.util.List;

final class StartDownloadCallback
implements DownloadCallback {
    private final SplitInstallInternalSessionState sessionState;
    private final int sessionId;
    private final SplitInstallSessionManager sessionManager;
    private final List<SplitInfo> splitInfoList;
    private final SplitSessionInstaller installer;

    StartDownloadCallback(SplitInstaller splitInstaller, int sessionId, SplitInstallSessionManager sessionManager, List<SplitInfo> splitInfoList) {
        this.sessionId = sessionId;
        this.sessionManager = sessionManager;
        this.installer = new SplitSessionInstallerImpl(splitInstaller, sessionManager, SplitInstallerExecutor.getExecutor());
        this.splitInfoList = splitInfoList;
        this.sessionState = sessionManager.getSessionState(sessionId);
    }

    public void onStart() {
        this.sessionManager.changeSessionState(this.sessionId, 2);
        this.broadcastSessionStatusChange();
    }

    public void onCanceled() {
        this.sessionManager.changeSessionState(this.sessionId, 7);
        this.broadcastSessionStatusChange();
    }

    public void onCanceling() {
        this.sessionManager.changeSessionState(this.sessionId, 9);
        this.broadcastSessionStatusChange();
    }

    public void onProgress(long currentBytes) {
        this.sessionState.setBytesDownloaded(currentBytes);
        this.sessionManager.changeSessionState(this.sessionId, 2);
        this.broadcastSessionStatusChange();
    }

    public void onCompleted() {
        this.sessionManager.changeSessionState(this.sessionId, 3);
        this.broadcastSessionStatusChange();
        this.onInstall();
    }

    public void onError(int errorCode) {
        this.sessionState.setErrorCode(-10);
        this.sessionManager.changeSessionState(this.sessionId, 6);
        this.broadcastSessionStatusChange();
    }

    private void onInstall() {
        this.installer.install(this.sessionId, this.splitInfoList);
    }

    private void broadcastSessionStatusChange() {
        this.sessionManager.emitSessionState(this.sessionState);
    }
}

