/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SignatureValidator;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;

final class SplitDownloadPreprocessor
implements Closeable {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final String TAG = "SplitDownloadPreprocessor";
    private final RandomAccessFile lockRaf;
    private final FileChannel lockChannel;
    private final FileLock cacheLock;
    private final File splitDir;
    private static final String LOCK_FILENAME = "SplitCopier.lock";

    SplitDownloadPreprocessor(File splitDir) throws IOException {
        this.splitDir = splitDir;
        File lockFile = new File(splitDir, LOCK_FILENAME);
        this.lockRaf = new RandomAccessFile(lockFile, "rw");
        try {
            this.lockChannel = this.lockRaf.getChannel();
            try {
                SplitLog.i((String)TAG, (String)("Blocking on lock " + lockFile.getPath()), (Object[])new Object[0]);
                this.cacheLock = this.lockChannel.lock();
            }
            catch (IOException | Error | RuntimeException var5) {
                FileUtil.closeQuietly((Object)this.lockChannel);
                throw var5;
            }
            SplitLog.i((String)TAG, (String)(lockFile.getPath() + " locked"), (Object[])new Object[0]);
        }
        catch (IOException | Error | RuntimeException var6) {
            FileUtil.closeQuietly((Object)this.lockRaf);
            throw var6;
        }
    }

    List<SplitFile> load(Context context, SplitInfo info, boolean verifySignature) throws IOException {
        if (!this.cacheLock.isValid()) {
            throw new IllegalStateException("FileCheckerAndCopier was closed");
        }
        ArrayList<SplitFile> downloadedSplitApkFiles = new ArrayList<SplitFile>();
        for (SplitInfo.ApkData apkData : info.getApkDataList(context)) {
            SplitFile splitApk = new SplitFile(this.splitDir, info.getSplitName() + "-" + apkData.getAbi() + ".apk", apkData.getSize());
            downloadedSplitApkFiles.add(splitApk);
            if (info.isBuiltIn()) {
                boolean builtInSplitInAssets = apkData.getUrl().startsWith("assets://");
                if (!splitApk.exists()) {
                    SplitLog.v((String)TAG, (String)"Built-in split %s is not existing, copy it from asset to %s", (Object[])new Object[]{info.getSplitName(), splitApk.getAbsolutePath()});
                    if (builtInSplitInAssets) {
                        SplitDownloadPreprocessor.copyBuiltInSplit(context, info.getSplitName(), apkData, splitApk);
                    }
                    if (this.verifySplitApk(context, apkData, splitApk, verifySignature)) continue;
                    throw new IOException(String.format("Failed to check built-in split %s, it may be corrupted", info.getSplitName()));
                }
                SplitLog.v((String)TAG, (String)"Built-in split %s is existing", (Object[])new Object[]{splitApk.getAbsolutePath()});
                if (this.verifySplitApk(context, apkData, splitApk, verifySignature)) continue;
                if (builtInSplitInAssets) {
                    SplitDownloadPreprocessor.copyBuiltInSplit(context, info.getSplitName(), apkData, splitApk);
                }
                if (this.verifySplitApk(context, apkData, splitApk, verifySignature)) continue;
                throw new IOException(String.format("Failed to check built-in split %s, it may be corrupted", splitApk.getAbsolutePath()));
            }
            if (splitApk.exists()) {
                SplitLog.v((String)TAG, (String)"split %s is downloaded", (Object[])new Object[]{info.getSplitName()});
                this.verifySplitApk(context, apkData, splitApk, verifySignature);
                continue;
            }
            SplitLog.v((String)TAG, (String)" split %s is not downloaded", (Object[])new Object[]{info.getSplitName()});
        }
        return downloadedSplitApkFiles;
    }

    private boolean verifySplitApk(Context context, SplitInfo.ApkData apkData, File splitApk, boolean verifySignature) {
        if (FileUtil.isLegalFile((File)splitApk)) {
            boolean ret;
            if (verifySignature) {
                ret = SignatureValidator.validateSplit(context, splitApk);
                if (ret) {
                    ret = SplitDownloadPreprocessor.checkSplitMD5(apkData, splitApk);
                }
            } else {
                ret = SplitDownloadPreprocessor.checkSplitMD5(apkData, splitApk);
            }
            if (!ret) {
                SplitLog.w((String)TAG, (String)"Oops! Failed to check file %s signature or md5", (Object[])new Object[]{splitApk.getAbsoluteFile()});
                this.deleteCorruptedOrObsoletedSplitApk();
            }
            return ret;
        }
        return false;
    }

    private static boolean checkSplitMD5(SplitInfo.ApkData apkData, File splitApk) {
        String apkMd5 = FileUtil.getMD5((File)splitApk);
        if (TextUtils.isEmpty((CharSequence)apkMd5)) {
            return apkData.getSize() == splitApk.length();
        }
        return apkData.getMd5().equals(apkMd5);
    }

    private void deleteCorruptedOrObsoletedSplitApk() {
        FileUtil.deleteDir((File)this.splitDir);
        if (this.splitDir.exists()) {
            SplitLog.w((String)TAG, (String)"Failed to delete corrupted split files", (Object[])new Object[0]);
        }
    }

    private static void copyBuiltInSplit(Context context, String splitName, SplitInfo.ApkData apkData, File splitApk) throws IOException {
        int numAttempts = 0;
        boolean isCopySuccessful = false;
        File tmpDir = SplitPathManager.require().getSplitTmpDir();
        File tmp = File.createTempFile("tmp-" + splitName, ".apk", tmpDir);
        String fileName = "qigsaw/" + splitName + "-" + apkData.getAbi() + ".zip";
        while (!isCopySuccessful && numAttempts < 3) {
            ++numAttempts;
            InputStream is = null;
            try {
                is = context.getAssets().open(fileName);
            }
            catch (IOException e1) {
                SplitLog.w((String)TAG, (String)("Built-in split apk " + fileName + " is not existing, attempts times : " + numAttempts), (Object[])new Object[0]);
            }
            if (is != null) {
                try {
                    FileUtil.copyFile((InputStream)is, (OutputStream)new FileOutputStream(tmp));
                    if (!tmp.renameTo(splitApk)) {
                        SplitLog.w((String)TAG, (String)("Failed to rename " + tmp.getAbsolutePath() + " to " + splitApk.getAbsolutePath()), (Object[])new Object[0]);
                    } else {
                        isCopySuccessful = true;
                    }
                }
                catch (IOException e) {
                    SplitLog.w((String)TAG, (String)("Failed to copy built-in split apk, attempts times : " + numAttempts), (Object[])new Object[0]);
                }
            }
            SplitLog.i((String)TAG, (String)("Copy built-in split " + (isCopySuccessful ? "succeeded" : "failed") + " '" + splitApk.getAbsolutePath() + "': length " + splitApk.length()), (Object[])new Object[0]);
            if (isCopySuccessful) continue;
            FileUtil.deleteFileSafely((File)splitApk);
            if (!splitApk.exists()) continue;
            SplitLog.w((String)TAG, (String)"Failed to delete copied file %s which has been corrupted ", (Object[])new Object[]{splitApk.getPath()});
        }
        FileUtil.deleteFileSafely((File)tmp);
        if (!isCopySuccessful) {
            throw new IOException(String.format("Failed to copy built-in file %s to path %s", fileName, splitApk.getPath()));
        }
    }

    @Override
    public void close() throws IOException {
        this.lockChannel.close();
        this.lockRaf.close();
        this.cacheLock.release();
    }

    static final class SplitFile
    extends File {
        long realSize;

        SplitFile(@Nullable File parent, @NonNull String child, long realSize) {
            super(parent, child);
            this.realSize = realSize;
        }
    }
}

