/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall.remote;

import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitPendingUninstallManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitUninstallReporterManager;
import com.iqiyi.android.qigsaw.core.splitreport.SplitUninstallReporter;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

final class SplitStartUninstallTask
implements Runnable {
    private static final String TAG = "SplitStartUninstallTask";
    private final List<SplitInfo> uninstallSplits;

    SplitStartUninstallTask(List<SplitInfo> uninstallSplits) {
        this.uninstallSplits = uninstallSplits;
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        ArrayList<String> realUninstallSplits = new ArrayList<String>(this.uninstallSplits.size());
        for (SplitInfo info : this.uninstallSplits) {
            SplitLog.d((String)TAG, (String)"split %s need to be uninstalled, try to delete its files", (Object[])new Object[]{info.getSplitName()});
            File splitRootDir = SplitPathManager.require().getSplitRootDir(info);
            FileUtil.deleteDir((File)splitRootDir);
            realUninstallSplits.add(info.getSplitName());
        }
        SplitUninstallReporter uninstallReporter = SplitUninstallReporterManager.getUninstallReporter();
        if (uninstallReporter != null) {
            uninstallReporter.onSplitUninstallOK(realUninstallSplits, System.currentTimeMillis() - time);
        }
        boolean result = new SplitPendingUninstallManager().deletePendingUninstallSplitsRecord();
        SplitLog.d((String)TAG, (String)"%s to delete record file of pending uninstall splits!", (Object[])new Object[]{result ? "Succeed" : "Failed"});
    }
}

