/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall.remote;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class SplitInstallSupervisor {
    public abstract void startInstall(List<Bundle> var1, Callback var2) throws RemoteException;

    public abstract void deferredInstall(List<Bundle> var1, Callback var2) throws RemoteException;

    public abstract void deferredUninstall(List<Bundle> var1, Callback var2) throws RemoteException;

    public abstract void cancelInstall(int var1, Callback var2) throws RemoteException;

    public abstract void getSessionState(int var1, Callback var2) throws RemoteException;

    public abstract void getSessionStates(Callback var1) throws RemoteException;

    public abstract boolean continueInstallWithUserConfirmation(int var1);

    public abstract boolean cancelInstallWithoutUserConfirmation(int var1);

    protected static Bundle bundleErrorCode(int errorCode) {
        Bundle bundle = new Bundle();
        bundle.putInt("error_code", errorCode);
        return bundle;
    }

    protected static List<String> unBundleModuleNames(Collection<Bundle> moduleNamesBundle) {
        ArrayList<String> moduleNames = new ArrayList<String>(moduleNamesBundle.size());
        for (Bundle bundle : moduleNamesBundle) {
            String moduleName = bundle.getString("module_name");
            moduleNames.add(moduleName);
        }
        return moduleNames;
    }

    protected static int createSessionId(Collection<SplitInfo> splitInfoList) {
        int sessionId = 0;
        for (SplitInfo info : splitInfoList) {
            String key = info.getSplitName() + "@" + info.getAppVersion() + "@" + info.getSplitVersion();
            sessionId += SplitInstallSupervisor.createSessionId(key);
        }
        return sessionId;
    }

    private static int createSessionId(String key) {
        byte[] hash;
        StringBuilder string = new StringBuilder();
        string.append(key);
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.toString().getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString().hashCode();
    }

    protected static boolean isNetworkAvailable(Context context) {
        NetworkInfo[] networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null && (networkInfo = connectivityManager.getAllNetworkInfo()).length > 0) {
            for (NetworkInfo info : networkInfo) {
                if (info.getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isMobileAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.getType() == 0;
        }
        return false;
    }

    public static interface Callback {
        public void onStartInstall(int var1, Bundle var2);

        public void onCancelInstall(int var1, Bundle var2);

        public void onGetSession(int var1, Bundle var2);

        public void onDeferredUninstall(Bundle var1);

        public void onDeferredInstall(Bundle var1);

        public void onGetSessionStates(List<Bundle> var1);

        public void onError(Bundle var1);
    }
}

