/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Context;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SignatureValidator;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

final class SplitDownloadPreprocessor
implements Closeable {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final String TAG = "SplitDownloadPreprocessor";
    private final File splitApk;
    private final RandomAccessFile lockRaf;
    private final FileChannel lockChannel;
    private final FileLock cacheLock;
    private final File splitDir;
    private static final String LOCK_FILENAME = "SplitCopier.lock";

    SplitDownloadPreprocessor(File splitDir, File splitApk) throws IOException {
        this.splitApk = splitApk;
        this.splitDir = splitDir;
        File lockFile = new File(splitDir, LOCK_FILENAME);
        this.lockRaf = new RandomAccessFile(lockFile, "rw");
        try {
            this.lockChannel = this.lockRaf.getChannel();
            try {
                SplitLog.i((String)TAG, (String)("Blocking on lock " + lockFile.getPath()), (Object[])new Object[0]);
                this.cacheLock = this.lockChannel.lock();
            }
            catch (IOException | Error | RuntimeException var5) {
                FileUtil.closeQuietly((Object)this.lockChannel);
                throw var5;
            }
            SplitLog.i((String)TAG, (String)(lockFile.getPath() + " locked"), (Object[])new Object[0]);
        }
        catch (IOException | Error | RuntimeException var6) {
            FileUtil.closeQuietly((Object)this.lockRaf);
            throw var6;
        }
    }

    void load(Context context, SplitInfo info, boolean verifySignature) throws IOException {
        if (!this.cacheLock.isValid()) {
            throw new IllegalStateException("FileCheckerAndCopier was closed");
        }
        String splitName = info.getSplitName();
        if (info.isBuiltIn()) {
            boolean builtInSplitInAssets = info.getUrl().startsWith("assets://");
            if (!this.splitApk.exists()) {
                SplitLog.v((String)TAG, (String)"Built-in split %s is not existing, copy it from asset to [%s]", (Object[])new Object[]{splitName, this.splitApk.getAbsolutePath()});
                if (builtInSplitInAssets) {
                    this.copyBuiltInSplit(context, info);
                }
                if (!this.verifySplitApk(context, info, verifySignature)) {
                    throw new IOException(String.format("Failed to check built-in split %s, it may be corrupted", splitName));
                }
            } else {
                SplitLog.v((String)TAG, (String)"Built-in split %s is existing", (Object[])new Object[]{this.splitApk.getAbsolutePath()});
                if (!this.verifySplitApk(context, info, verifySignature)) {
                    if (builtInSplitInAssets) {
                        this.copyBuiltInSplit(context, info);
                    }
                    if (!this.verifySplitApk(context, info, verifySignature)) {
                        throw new IOException(String.format("Failed to check built-in split %s, it may be corrupted", this.splitApk.getAbsolutePath()));
                    }
                }
            }
        } else if (this.splitApk.exists()) {
            SplitLog.v((String)TAG, (String)"split %s is downloaded", (Object[])new Object[]{splitName});
            this.verifySplitApk(context, info, verifySignature);
        } else {
            SplitLog.v((String)TAG, (String)" split %s is not downloaded", (Object[])new Object[]{splitName});
        }
    }

    private boolean verifySplitApk(Context context, SplitInfo info, boolean verifySignature) {
        if (FileUtil.isLegalFile((File)this.splitApk)) {
            boolean ret;
            if (verifySignature) {
                ret = SignatureValidator.validateSplit(context, this.splitApk);
                if (ret) {
                    ret = this.checkSplitMD5(info);
                }
            } else {
                ret = this.checkSplitMD5(info);
            }
            if (!ret) {
                SplitLog.w((String)TAG, (String)"Oops! Failed to check split %s signature and md5", (Object[])new Object[]{info.getSplitName()});
                this.deleteCorruptedOrObsoletedSplitApk();
            }
            return ret;
        }
        return false;
    }

    private boolean checkSplitMD5(SplitInfo info) {
        String apkMd5 = FileUtil.getMD5((File)this.splitApk);
        if (TextUtils.isEmpty((CharSequence)apkMd5)) {
            return info.getSize() == this.splitApk.length();
        }
        return info.getMd5().equals(apkMd5);
    }

    private void deleteCorruptedOrObsoletedSplitApk() {
        FileUtil.deleteDir((File)this.splitDir);
        if (this.splitDir.exists()) {
            SplitLog.w((String)TAG, (String)"Failed to delete corrupted split files", (Object[])new Object[0]);
        }
    }

    private void copyBuiltInSplit(Context context, SplitInfo info) throws IOException {
        int numAttempts = 0;
        boolean isCopySuccessful = false;
        String splitFileName = info.getSplitName() + ".zip";
        File tmpDir = SplitPathManager.require().getSplitTmpDir();
        File tmp = File.createTempFile("tmp-" + info.getSplitName(), ".apk", tmpDir);
        while (!isCopySuccessful && numAttempts < 3) {
            ++numAttempts;
            try {
                InputStream is = context.getAssets().open(splitFileName);
                FileUtil.copyFile((InputStream)is, (OutputStream)new FileOutputStream(tmp));
                if (!tmp.renameTo(this.splitApk)) {
                    SplitLog.w((String)TAG, (String)("Failed to rename \"" + tmp.getAbsolutePath() + "\" to \"" + this.splitApk.getAbsolutePath() + "\""), (Object[])new Object[0]);
                } else {
                    isCopySuccessful = true;
                }
            }
            catch (IOException e) {
                SplitLog.w((String)TAG, (String)("Failed to copy built-in split apk, attempts times : " + numAttempts), (Object[])new Object[0]);
            }
            SplitLog.i((String)TAG, (String)("Copy built-in split " + (isCopySuccessful ? "succeeded" : "failed") + " '" + this.splitApk.getAbsolutePath() + "': length " + this.splitApk.length()), (Object[])new Object[0]);
            if (isCopySuccessful) continue;
            FileUtil.deleteFileSafely((File)this.splitApk);
            if (!this.splitApk.exists()) continue;
            SplitLog.w((String)TAG, (String)("Failed to delete copied split apk which has been corrupted'" + this.splitApk.getPath() + "'"), (Object[])new Object[0]);
        }
        FileUtil.deleteFileSafely((File)tmp);
        if (!isCopySuccessful) {
            throw new IOException(String.format("Failed to copy built-in file %s to path %s", splitFileName, this.splitApk.getPath()));
        }
    }

    @Override
    public void close() throws IOException {
        this.lockChannel.close();
        this.lockRaf.close();
        this.cacheLock.release();
    }
}

