/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitCleanService
extends IntentService {
    private static final String TAG = "SplitCleanService";
    private static final int MAX_SPLIT_CACHE_SIZE = 1;

    public SplitCleanService() {
        super("qigsaw_split_clean");
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            this.doClean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doClean() {
        Collection splitInfoList;
        SplitPathManager.require().clearCache();
        SplitInfoManager infoManager = SplitInfoManagerService.getInstance();
        if (infoManager != null && (splitInfoList = infoManager.getAllSplitInfo((Context)this)) != null) {
            for (SplitInfo splitInfo : splitInfoList) {
                File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
                File splitRootDir = SplitPathManager.require().getSplitRootDir(splitInfo);
                this.deleteRedundantSplitVersionDirs(splitDir, splitRootDir);
            }
        }
    }

    private void deleteRedundantSplitVersionDirs(final File currentSplitVersionDir, File splitRootDir) {
        final String splitName = splitRootDir.getName();
        File[] files = splitRootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(currentSplitVersionDir)) {
                    File markFile = new File(pathname, String.valueOf(splitName.hashCode()));
                    SplitLog.i((String)SplitCleanService.TAG, (String)"Split %s version %s has been installed!", (Object[])new Object[]{splitName, pathname.getName()});
                    return markFile.exists();
                }
                return false;
            }
        });
        if (files != null && files.length > 1) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (o1.lastModified() < o2.lastModified()) {
                        return 1;
                    }
                    if (o1.lastModified() == o2.lastModified()) {
                        return 0;
                    }
                    return -1;
                }
            });
            for (int i = 1; i < files.length; ++i) {
                SplitLog.i((String)TAG, (String)"Split %s version %s is redundant, so wen try to delete it", (Object[])new Object[]{splitName, files[i].getName()});
                FileUtil.deleteDir((File)files[i]);
            }
        }
    }
}

