/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall.remote;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.splitinstall.protocol.ISplitInstallService;
import com.iqiyi.android.qigsaw.core.splitinstall.protocol.ISplitInstallServiceCallback;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.OnCancelInstallTask;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.OnDeferredInstallTask;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.OnDeferredUninstallTask;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.OnGetSessionStateTask;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.OnGetSessionStatesTask;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.OnStartInstallTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SplitInstallService
extends Service {
    private static final Map<String, Handler> sHandlerMap = Collections.synchronizedMap(new HashMap());
    ISplitInstallService.Stub mBinder = new ISplitInstallService.Stub(){

        @Override
        public void startInstall(String packageName, List<Bundle> moduleNames, Bundle versionCode, ISplitInstallServiceCallback callback) {
            SplitInstallService.this.getHandler(packageName).post((Runnable)new OnStartInstallTask(callback, moduleNames));
        }

        @Override
        public void cancelInstall(String packageName, int sessionId, Bundle versionCode, ISplitInstallServiceCallback callback) {
            SplitInstallService.this.getHandler(packageName).post((Runnable)new OnCancelInstallTask(callback, sessionId));
        }

        @Override
        public void getSessionState(String packageName, int sessionId, ISplitInstallServiceCallback callback) {
            SplitInstallService.this.getHandler(packageName).post((Runnable)new OnGetSessionStateTask(callback, sessionId));
        }

        @Override
        public void getSessionStates(String packageName, ISplitInstallServiceCallback callback) {
            SplitInstallService.this.getHandler(packageName).post((Runnable)new OnGetSessionStatesTask(callback));
        }

        @Override
        public void deferredInstall(String packageName, List<Bundle> moduleNames, Bundle versionCode, ISplitInstallServiceCallback callback) {
            SplitInstallService.this.getHandler(packageName).post((Runnable)new OnDeferredInstallTask(callback, moduleNames));
        }

        @Override
        public void deferredUninstall(String packageName, List<Bundle> moduleNames, Bundle versionCode, ISplitInstallServiceCallback callback) {
            SplitInstallService.this.getHandler(packageName).post((Runnable)new OnDeferredUninstallTask(callback, moduleNames));
        }
    };

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler(String packageName) {
        Handler handler;
        Map<String, Handler> map = sHandlerMap;
        synchronized (map) {
            if (!sHandlerMap.containsKey(packageName)) {
                HandlerThread handlerThread = new HandlerThread("split_remote_" + packageName, 10);
                handlerThread.start();
                sHandlerMap.put(packageName, new Handler(handlerThread.getLooper()));
            }
            handler = sHandlerMap.get(packageName);
        }
        return handler;
    }
}

