/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitreport.SplitBriefInfo;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class SplitInstallTask
implements Runnable {
    private static final String TAG = "SplitInstallTask";
    private final SplitInstaller installer;
    private final Collection<SplitInfo> needUpdateSplits;
    final List<SplitBriefInfo> splitBriefInfoList;

    SplitInstallTask(SplitInstaller installer, Collection<SplitInfo> needUpdateSplits) {
        this.installer = installer;
        this.needUpdateSplits = needUpdateSplits;
        this.splitBriefInfoList = this.createSplitBriefInfoList(needUpdateSplits);
    }

    private List<SplitBriefInfo> createSplitBriefInfoList(Collection<SplitInfo> needUpdateSplits) {
        ArrayList<SplitBriefInfo> splitBriefInfoList = new ArrayList<SplitBriefInfo>(needUpdateSplits.size());
        for (SplitInfo info : needUpdateSplits) {
            splitBriefInfoList.add(new SplitBriefInfo(info.getSplitName(), info.getSplitVersion(), info.isBuiltIn()));
        }
        return splitBriefInfoList;
    }

    abstract boolean isStartInstallOperation();

    @Override
    public final void run() {
        this.onPreInstall();
        long currentTime = System.currentTimeMillis();
        ArrayList<SplitInstaller.InstallResult> installResults = new ArrayList<SplitInstaller.InstallResult>();
        ArrayList<SplitInstallError> installErrors = new ArrayList<SplitInstallError>(0);
        boolean installCompleted = true;
        boolean isStartInstall = this.isStartInstallOperation();
        for (SplitInfo info : this.needUpdateSplits) {
            try {
                SplitInstaller.InstallResult installResult = this.installer.install(isStartInstall, info);
                installResults.add(installResult);
            }
            catch (SplitInstaller.InstallException error) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)error, (String)("Failed to install split " + info.getSplitName()), (Object[])new Object[0]);
                installCompleted = false;
                installErrors.add(new SplitInstallError(info.getSplitName(), info.getSplitVersion(), info.isBuiltIn(), error.getErrorCode(), error.getCause()));
                if (!isStartInstall) continue;
                break;
            }
        }
        if (installCompleted) {
            this.onInstallCompleted(installResults, System.currentTimeMillis() - currentTime);
        } else {
            this.onInstallFailed(installErrors, System.currentTimeMillis() - currentTime);
        }
    }

    protected void onPreInstall() {
    }

    abstract void onInstallCompleted(List<SplitInstaller.InstallResult> var1, long var2);

    abstract void onInstallFailed(List<SplitInstallError> var1, long var2);
}

